/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeletingInputStream
extends InputStream {
    private static Logger log = LoggerFactory.getLogger(FileDeletingInputStream.class);
    private File tempFile;
    private InputStream wrapped;

    public FileDeletingInputStream(File tempFile) throws FileNotFoundException {
        this.tempFile = tempFile;
        this.wrapped = new FileInputStream(tempFile);
    }

    @Override
    public int read() throws IOException {
        return this.wrapped.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.wrapped.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrapped.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrapped.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.wrapped.close();
        }
        finally {
            if (!this.tempFile.delete()) {
                log.error("Failed to delete: " + this.tempFile.getAbsolutePath());
            } else {
                this.tempFile = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.tempFile != null && this.tempFile.exists()) {
            log.error("temporary file was not deleted. Was close called on the inputstream? Will attempt to delete: " + this.tempFile.getAbsolutePath());
            if (!this.tempFile.delete()) {
                log.error("Still couldnt delete temporary file: " + this.tempFile.getAbsolutePath());
            }
        }
        super.finalize();
    }
}

