/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.http11.ETagGenerator;
import com.bradmcevoy.http.http11.MatchHelper;
import java.util.ArrayList;
import java.util.List;

public class DefaultMatchHelper
implements MatchHelper {
    private final ETagGenerator eTagGenerator;

    public DefaultMatchHelper(ETagGenerator eTagGenerator) {
        this.eTagGenerator = eTagGenerator;
    }

    @Override
    public boolean checkIfMatch(Resource r, Request req) {
        String h = req.getIfMatchHeader();
        if (h == null || h.length() == 0) {
            return true;
        }
        if (r == null) {
            return false;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null || currentEtag.length() == 0) {
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            if (!requestedEtag.equals(currentEtag) && !requestedEtag.equals("*")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkIfNoneMatch(Resource r, Request req) {
        String h = req.getIfNoneMatchHeader();
        if (h == null) {
            return false;
        }
        if (h.equals("*")) {
            boolean b;
            boolean bl = b = r != null;
            if (b) {
                System.out.println("if-none-match header is star, and a resource exists");
            }
            return b;
        }
        String currentEtag = this.eTagGenerator.generateEtag(r);
        if (currentEtag == null) {
            return false;
        }
        List<String> etags = this.splitToList(h);
        for (String requestedEtag : etags) {
            if (!requestedEtag.equals(currentEtag)) continue;
            System.out.println("found existing etag: " + currentEtag);
            return true;
        }
        return false;
    }

    private List<String> splitToList(String s) {
        String[] arr = s.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String part : arr) {
            if ((part = part.trim()).length() <= 0) continue;
            list.add(part.trim());
        }
        return list;
    }
}

