/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.ObjectList;

public final class TokenList
extends ObjectList<byte[], TokenList> {
    public TokenList() {
        this(8L);
    }

    public TokenList(long capacity) {
        super((E[])new byte[Array.checkCapacity(capacity)][]);
    }

    public TokenList(double factor) {
        super((E[])new byte[0][]);
        this.factor = (byte)Math.max(10, (byte)(factor * 10.0));
    }

    public TokenList(TokenSet set) {
        this(set.size());
        for (byte[] e : set) {
            this.add(e);
        }
    }

    public TokenList(byte[] ... elements) {
        super((E[])elements);
        this.size = elements.length;
    }

    @Override
    public TokenList add(long element) {
        this.add(Token.token(element));
        return this;
    }

    @Override
    public TokenList add(String element) {
        this.add(Token.token(element));
        return this;
    }

    @Override
    public boolean equals(byte[] element1, byte[] element2) {
        return Token.eq(element1, element2);
    }

    public TokenList sort() {
        return this.sort(true);
    }

    public TokenList sort(boolean cs) {
        return this.sort(cs, true);
    }

    public TokenList sort(boolean cs, boolean ascending) {
        return (TokenList)this.sort(cs ? Token.COMPARATOR : Token.LC_COMPARATOR, ascending);
    }

    protected byte[][] newArray(int s) {
        return new byte[s][];
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(91);
        for (byte[] token : this) {
            if (tb.size() > 1) {
                tb.add(", ");
            }
            tb.add(token);
        }
        return tb.add(93).toString();
    }
}

