/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ObjectList;

public class StringList
extends ObjectList<String, StringList> {
    public StringList() {
        this(8L);
    }

    public StringList(long capacity) {
        super(new String[Array.checkCapacity(capacity)]);
    }

    public StringList(String ... elements) {
        super(elements);
        this.size = elements.length;
    }

    @Override
    public StringList add(byte[] element) {
        return (StringList)((Object)this.add(Token.string(element)));
    }

    public final StringList sort() {
        return this.sort(true);
    }

    public final StringList sort(boolean cs) {
        return this.sort(cs, true);
    }

    public final StringList sort(boolean cs, boolean asc) {
        Comparator comp = cs ? null : String.CASE_INSENSITIVE_ORDER;
        Arrays.sort((String[])this.list, 0, this.size, asc ? comp : Collections.reverseOrder(comp));
        return this;
    }

    protected final String[] newArray(int s) {
        return new String[s];
    }
}

