/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.ASet;

public class WeakTokenSet
extends ASet {
    protected WeakTokenRef[] keys;
    protected ReferenceQueue<byte[]> gcedKeys = new ReferenceQueue();
    protected int free;

    public WeakTokenSet() {
        super(8L);
        this.keys = new WeakTokenRef[this.capacity()];
    }

    public final byte[] put(byte[] key) {
        int s;
        int h = Token.hash(key);
        int c = this.capacity();
        int b = h & c - 1;
        int id2 = this.buckets[b];
        while (id2 != 0) {
            byte[] stored = (byte[])this.keys[id2].get();
            if (Token.eq(key, stored)) {
                return stored;
            }
            id2 = this.next[id2];
        }
        if (this.size == c && this.free == 0) {
            this.cleanUp();
        }
        if (this.free != 0) {
            s = this.free;
            this.free = this.next[s];
        } else {
            if (this.checkCapacity((id, bucket) -> {
                this.keys[id.intValue()].bucket = bucket;
            })) {
                b = h & this.capacity() - 1;
            }
            s = this.size++;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = new WeakTokenRef(key, b, this.gcedKeys);
        this.buckets[b] = s;
        return key;
    }

    protected void cleanUp() {
        WeakTokenRef key;
        block0: while ((key = (WeakTokenRef)this.gcedKeys.poll()) != null) {
            int b = key.bucket;
            int p = 0;
            int id = this.buckets[b];
            while (true) {
                if (id == 0) {
                    throw Util.notExpected();
                }
                if (key == this.keys[id]) {
                    if (p == 0) {
                        this.buckets[b] = this.next[id];
                    } else {
                        this.next[p] = this.next[id];
                    }
                    this.keys[id] = null;
                    this.next[id] = this.free;
                    this.free = id;
                    continue block0;
                }
                p = id;
                id = this.next[id];
            }
        }
    }

    @Override
    protected int hash(int id) {
        byte[] token = (byte[])this.keys[id].get();
        return token == null ? this.keys[id].bucket : Token.hash(token);
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Arrays.copyOf(this.keys, newSize);
    }

    @Override
    public void clear() {
        this.gcedKeys = new ReferenceQueue();
        this.free = 0;
        Arrays.fill(this.keys, null);
        super.clear();
    }

    public String toString() {
        return this.toString(this.keys);
    }

    private static final class WeakTokenRef
    extends WeakReference<byte[]> {
        private int bucket;

        private WeakTokenRef(byte[] key, int bucket, ReferenceQueue<byte[]> queue) {
            super(key, queue);
            this.bucket = bucket;
        }

        public String toString() {
            byte[] token = (byte[])this.get();
            return token == null ? "null" : Token.string(token);
        }
    }
}

