/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

public class TokenMap
extends TokenSet {
    private byte[][] values = new byte[this.capacity()][];

    public TokenMap() {
        this(8L);
    }

    public TokenMap(long capacity) {
        super(capacity);
    }

    public final void put(byte[] key, byte[] value) {
        int i = this.put(key);
        this.values[i] = value;
    }

    public final void put(String key, String value) {
        this.put(Token.token(key), Token.token(value));
    }

    public final byte[] get(byte[] key) {
        return key != null ? this.values[this.id(key)] : null;
    }

    @Override
    public int remove(byte[] key) {
        int i = super.remove(key);
        this.values[i] = null;
        return i;
    }

    public final Iterable<byte[]> values() {
        return new ArrayIterator<byte[]>((Object[])this.values, 1, this.size);
    }

    @Override
    public final void clear() {
        Arrays.fill((Object[])this.values, null);
        super.clear();
    }

    @Override
    protected final void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Array.copyOf(this.values, newSize);
    }

    @Override
    public String toString() {
        return this.toString((Object[])this.keys, (Object[])this.values);
    }
}

