/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Arrays;
import java.util.Collection;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;
import org.basex.util.hash.TokenMap;

final class EnglishStemmer
extends InternalStemmer {
    private static final TokenMap DICTIONARY = Util.properties("stemmer-en.properties");
    private static final byte[] AT = Token.token("at");
    private static final byte[] BL = Token.token("bl");
    private static final byte[] ED = Token.token("ed");
    private static final byte[] EED = Token.token("eed");
    private static final byte[] IES = Token.token("ies");
    private static final byte[] ING = Token.token("ing");
    private static final byte[] ION = Token.token("ion");
    private static final byte[] IZ = Token.token("iz");
    private static final byte[] LL = Token.token("ll");
    private static final byte[] SION = Token.token("sion");
    private static final byte[] SSES = Token.token("sses");
    private static final byte[] TION = Token.token("tion");
    private static final byte S = 115;
    private static final byte Y = 121;
    private static final byte E = 101;
    private static final byte L = 108;
    private static final byte[][][] ST2 = new byte[][][]{Token.tokens("abli", "able"), Token.tokens("alism", "al"), Token.tokens("aliti", "al"), Token.tokens("alli", "al"), Token.tokens("anci", "ance"), Token.tokens("ation", "ate"), Token.tokens("ational", "ate"), Token.tokens("ator", "ate"), Token.tokens("biliti", "ble"), Token.tokens("eli", "e"), Token.tokens("enci", "ence"), Token.tokens("entli", "ent"), Token.tokens("fulness", "ful"), Token.tokens("iveness", "ive"), Token.tokens("iviti", "ive"), Token.tokens("ization", "ize"), Token.tokens("ization", "ize"), Token.tokens("izer", "ize"), Token.tokens("izer", "ize"), Token.tokens("ousli", "ous"), Token.tokens("ousness", "ous"), Token.tokens("tional", "tion")};
    private static final byte[][][] ST3 = new byte[][][]{Token.tokens("alize", "al"), Token.tokens("alize", "al"), Token.tokens("ative", ""), Token.tokens("ful", ""), Token.tokens("ical", "ic"), Token.tokens("icate", "ic"), Token.tokens("iciti", "ic"), Token.tokens("ness", "")};
    private static final byte[][] ST4 = Token.tokens("able", "al", "ance", "ant", "ate", "ement", "ence", "ent", "er", "ible", "ic", "ism", "iti", "ive", "ize", "ment", "ou", "ous", "sion", "tion");
    private byte[] token;
    private int tl;
    private int tt;

    EnglishStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new EnglishStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return EnglishStemmer.collection("en");
    }

    @Override
    protected byte[] stem(byte[] str) {
        byte[] s = DICTIONARY.get(str);
        if (s != null) {
            return s;
        }
        this.tl = str.length;
        this.token = str;
        return this.s() ? Arrays.copyOf(str, this.tl) : str;
    }

    private boolean s() {
        int n;
        if (this.tl < 3) {
            return false;
        }
        if (this.e((byte)115)) {
            if (this.e(SSES) || this.e(IES)) {
                this.tl -= 2;
            } else if (this.l(this.tl - 2) != 115) {
                --this.tl;
            }
        }
        if (this.e(EED)) {
            if (this.m() > 0) {
                --this.tl;
            }
        } else if ((this.e(ED) || this.e(ING)) && this.v()) {
            this.tl = this.tt;
            if (this.e(AT) || this.e(BL) || this.e(IZ)) {
                this.tt = this.tl;
                this.a((byte)101);
            } else if (this.tl > 1) {
                int n2 = this.l(this.tl - 1);
                if (n2 == this.l(this.tl - 2) && n2 != 108 && n2 != 115 && n2 != 122) {
                    --this.tl;
                } else if (this.m() == 1 && this.c(this.tl)) {
                    this.a((byte)101);
                }
            }
        }
        if (this.e((byte)121) && this.v()) {
            this.a((byte)105);
        }
        for (Object s : ST2) {
            if (!this.e(s[0])) continue;
            if (this.m() <= 0) break;
            this.a(s[1]);
            break;
        }
        for (Object s : ST3) {
            if (!this.e(s[0])) continue;
            if (this.m() <= 0) break;
            this.a(s[1]);
            break;
        }
        if ((this.e(TION) || this.e(SION)) && this.e(ION) && this.m() > 1) {
            this.tl -= 3;
        } else {
            byte[][] byArray = ST4;
            int n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                Object s;
                s = byArray[i];
                if (!this.e((byte[])s)) continue;
                if (this.m() <= 1) break;
                this.tl = this.tt;
                break;
            }
        }
        if (this.e((byte)101) && ((n = this.m()) > 1 || n == 1 && !this.c(this.tl - 1))) {
            --this.tl;
        }
        if (this.e(LL) && this.e((byte)108) && this.m() > 1) {
            --this.tl;
        }
        return this.tl != this.token.length;
    }

    private boolean c(int l) {
        if (l < 3) {
            return false;
        }
        int c = this.l(l - 1);
        return c != 119 && c != 120 && c != 121 && !this.v(l - 1) && this.v(l - 2) && !this.v(l - 3);
    }

    private boolean e(byte[] s) {
        int sl = s.length;
        int l = this.tl - sl;
        if (l < 0) {
            return false;
        }
        for (int i = 0; i < sl; ++i) {
            if (this.l(l + i) == s[i]) continue;
            return false;
        }
        this.tt = l;
        return true;
    }

    private boolean e(byte s) {
        int l = this.tl - 1;
        if (l < 0 || this.l(l) != s) {
            return false;
        }
        this.tt = l;
        return true;
    }

    private int m() {
        int c = 0;
        int i = -1;
        boolean v = false;
        while (++i < this.tt) {
            if (!(v ^ this.v(i))) continue;
            if (v) {
                ++c;
            }
            v ^= true;
        }
        return c;
    }

    private boolean v() {
        for (int i = 0; i < this.tt; ++i) {
            if (!this.v(i)) continue;
            return true;
        }
        return false;
    }

    private boolean v(int p) {
        int c = this.l(p);
        return c == 97 || c == 101 || c == 105 || c == 111 || c == 117 || c == 121 && p != 0 && !this.v(p - 1);
    }

    private int l(int p) {
        return Token.lc(this.token[p]);
    }

    private void a(byte c) {
        this.tl = this.tt;
        this.token[this.tl++] = c;
    }

    private void a(byte[] t) {
        this.tl = this.tt;
        for (byte c : t) {
            this.token[this.tl++] = c;
        }
    }
}

