/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.TokenList;
import org.basex.util.similarity.Levenshtein;

public final class XMLToken {
    private static TokenMap entities;
    private static final byte[] UNDERSCORE;

    private XMLToken() {
    }

    public static boolean valid(int cp) {
        return cp < 55296 ? cp >= 32 || cp == 10 || cp == 9 || cp == 13 : cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }

    public static boolean isNCStartChar(int cp) {
        return cp < 128 ? cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp == 95 : (cp < 768 ? cp >= 192 && cp != 215 && cp != 247 : cp >= 880 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12031 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039);
    }

    public static boolean isNCChar(int cp) {
        return XMLToken.isNCStartChar(cp) || (cp < 256 ? Token.digit(cp) || cp == 45 || cp == 46 || cp == 183 : cp >= 768 && cp <= 879 || cp == 8255 || cp == 8256);
    }

    public static boolean isStartChar(int cp) {
        return XMLToken.isNCStartChar(cp) || cp == 58;
    }

    public static boolean isChar(int cp) {
        return XMLToken.isNCChar(cp) || cp == 58;
    }

    public static boolean isNCName(byte[] value) {
        int l = value.length;
        return l != 0 && XMLToken.ncName(value, 0) == l;
    }

    public static boolean isName(byte[] value) {
        int l = value.length;
        for (int i = 0; i < l; i += Token.cl(value, i)) {
            int cp = Token.cp(value, i);
            if (!(i == 0 ? !XMLToken.isStartChar(cp) : !XMLToken.isChar(cp))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isNMToken(byte[] value) {
        int l = value.length;
        for (int i = 0; i < l; i += Token.cl(value, i)) {
            if (XMLToken.isChar(Token.cp(value, i))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isQName(byte[] value) {
        int l = value.length;
        if (l == 0) {
            return false;
        }
        int i = XMLToken.ncName(value, 0);
        if (i == l) {
            return true;
        }
        if (i == 0 || value[i] != 58) {
            return false;
        }
        int j = XMLToken.ncName(value, i + 1);
        return j == l && j != i + 1;
    }

    private static int ncName(byte[] value, int start) {
        int l = value.length;
        for (int i = start; i < l; i += Token.cl(value, i)) {
            int c = Token.cp(value, i);
            if (!(i == start ? !XMLToken.isNCStartChar(c) : !XMLToken.isNCChar(c))) continue;
            return i;
        }
        return l;
    }

    public static boolean isId(byte[] name, boolean idref) {
        byte[] n = Token.lc(Token.local(name));
        return idref ? Token.contains(n, Token.REF) : Token.contains(n, Token.ID) && !Token.contains(n, Token.REF);
    }

    public static byte[] encode(byte[] name, boolean lax) {
        byte[] nm = lax ? Token.trim(name) : name;
        int nl = nm.length;
        if (nl == 0) {
            return UNDERSCORE;
        }
        for (int n = 0; n < nl; n += Token.cl(nm, n)) {
            int cp = Token.cp(nm, n);
            if (cp != 95 && !(n == 0 ? !XMLToken.isNCStartChar(cp) : !XMLToken.isNCChar(cp))) continue;
            TokenBuilder tb = new TokenBuilder((long)nl << 1).add(nm, 0, n);
            for (int m = n; m < nl; m += Token.cl(nm, m)) {
                cp = Token.cp(nm, m);
                if (lax) {
                    boolean nc = XMLToken.isNCChar(cp);
                    if (m == 0 && nc && !XMLToken.isNCStartChar(cp)) {
                        tb.add(95);
                    }
                    tb.add(nc ? cp : 95);
                    continue;
                }
                if (cp == 95) {
                    tb.add(95).add(95);
                    continue;
                }
                if (m == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) {
                    tb.add(cp);
                    continue;
                }
                if (cp < 65536) {
                    XMLToken.addEsc(tb, cp);
                    continue;
                }
                int r = cp - 65536;
                XMLToken.addEsc(tb, (r >>> 10) + 55296);
                XMLToken.addEsc(tb, (r & 0x3FF) + 56320);
            }
            return tb.finish();
        }
        return nm;
    }

    private static void addEsc(TokenBuilder tb, int cp) {
        tb.addByte(UNDERSCORE[0]);
        int a = cp >>> 12;
        tb.addByte((byte)(a + (a > 9 ? 87 : 48)));
        int b = cp >>> 8 & 0xF;
        tb.addByte((byte)(b + (b > 9 ? 87 : 48)));
        int c = cp >>> 4 & 0xF;
        tb.addByte((byte)(c + (c > 9 ? 87 : 48)));
        int d = cp & 0xF;
        tb.addByte((byte)(d + (d > 9 ? 87 : 48)));
    }

    public static byte[] decode(byte[] name, boolean lax) {
        int nl = name.length;
        if (nl == 0) {
            return null;
        }
        if (lax) {
            return name;
        }
        TokenBuilder tb = new TokenBuilder();
        int mode = 0;
        int uc = 0;
        int n = 0;
        while (n < nl) {
            int cp = Token.cp(name, n);
            if (mode >= 3) {
                uc <<= 4;
                if (cp >= 48 && cp <= 57) {
                    uc += cp - 48;
                } else if (cp >= 65 && cp <= 70) {
                    uc += cp - 55;
                } else if (cp >= 97 && cp <= 102) {
                    uc += cp - 87;
                } else {
                    return null;
                }
                if (++mode == 7) {
                    tb.add(uc);
                    mode = 0;
                    uc = 0;
                }
            } else if (cp == 95) {
                if (++mode == 3) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
            } else {
                if (mode == 1) {
                    mode = 3;
                    continue;
                }
                if (mode == 2) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
                if (!(!tb.isEmpty() ? XMLToken.isNCChar(cp) : XMLToken.isNCStartChar(cp))) {
                    return null;
                }
                tb.add(cp);
                mode = 0;
            }
            n += Token.cl(name, n);
        }
        if (mode == 2) {
            tb.add(95);
        } else if (mode == 1 && !tb.isEmpty() || mode >= 3) {
            return null;
        }
        return tb.finish();
    }

    public static int invalid(byte[] token) {
        TokenParser tp = new TokenParser(token);
        while (tp.more()) {
            int cp = tp.next();
            if (XMLToken.valid(cp)) continue;
            return cp;
        }
        return -1;
    }

    public static byte[] getEntity(byte[] key) {
        return XMLToken.entities().get(key);
    }

    public static Object similarEntity(byte[] key) {
        TokenMap map = XMLToken.entities();
        TokenList list = new TokenList(map.size());
        for (byte[] entity : map) {
            list.add(entity);
        }
        return Levenshtein.similar(key, list.finish());
    }

    private static TokenMap entities() {
        if (entities == null) {
            entities = Util.properties("entities.properties");
        }
        return entities;
    }

    static {
        UNDERSCORE = new byte[]{95};
    }
}

