/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.core.BaseXException;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;

public final class XMLAccess {
    private XMLAccess() {
    }

    public static BasicNodeIter children(ANode node) {
        return XMLAccess.children(node, null);
    }

    public static BasicNodeIter children(ANode node, final QNm name) {
        final BasicNodeIter children = node.childIter();
        return new BasicNodeIter(){

            @Override
            public ANode next() {
                ANode child;
                while ((child = children.next()) != null) {
                    if (child.type != NodeType.ELEMENT || name != null && !name.eq(child.qname())) continue;
                    return child;
                }
                return null;
            }
        };
    }

    public static byte[] attribute(ANode node, QNm name, String info) throws BaseXException {
        byte[] value = node.attribute(name);
        if (value != null) {
            return value;
        }
        throw new BaseXException("%: Missing \"%\" attribute.", info, name);
    }

    public static <E extends Enum<E>> E attribute(String prefix, ANode node, QNm name, E[] values) throws BaseXException {
        return (E)XMLAccess.value((String)prefix, (byte[])XMLAccess.attribute(node, name, prefix), values);
    }

    public static <E extends Enum<E>> E value(String prefix, byte[] name, E[] names) throws BaseXException {
        String n = Token.string(name);
        for (E nm : names) {
            if (!n.equals(((Enum)nm).toString())) continue;
            return nm;
        }
        throw new BaseXException("%: Unexpected element: \"%\".", prefix, name);
    }
}

