/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Supplier;
import org.basex.io.out.ArrayOutput;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ByteList;
import org.basex.util.list.TokenList;

public final class Token {
    public static final byte[] EMPTY = new byte[0];
    public static final byte[] XML = Token.token("xml");
    public static final byte[] XML_COLON = Token.token("xml:");
    public static final byte[] XMLNS = Token.token("xmlns");
    public static final byte[] XMLNS_COLON = Token.token("xmlns:");
    public static final byte[] ID = Token.token("id");
    public static final byte[] REF = Token.token("ref");
    public static final byte[] TRUE = Token.token("true");
    public static final byte[] FALSE = Token.token("false");
    public static final byte[] NAN = Token.token("NaN");
    public static final byte[] INF = Token.token("INF");
    public static final byte[] NEGATVE_INF = Token.token("-INF");
    public static final byte[] INFINITY = Token.token("Infinity");
    public static final byte[] NEGATIVE_INFINITY = Token.token("-Infinity");
    public static final byte[] MIN_LONG = Token.token("-9223372036854775808");
    public static final byte[] MIN_INT = Token.token("-2147483648");
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] ZERO = new byte[]{48};
    public static final byte[] NEGATIVE_ZERO = new byte[]{45, 48};
    public static final byte[] ONE = new byte[]{49};
    public static final byte[] SLASH = new byte[]{47};
    public static final byte[] COLON = new byte[]{58};
    public static final byte[] DOLLAR = new byte[]{36};
    public static final Comparator<byte[]> COMPARATOR = Token::diff;
    public static final Comparator<byte[]> LC_COMPARATOR = (o1, o2) -> Token.diff(Token.lc(o1), Token.lc(o2));
    public static final char REPLACEMENT = '\ufffd';
    public static final DecimalFormatSymbols LOC = new DecimalFormatSymbols(Locale.US);
    public static final DecimalFormat SD = new DecimalFormat("0.0##################E0", LOC);
    public static final DecimalFormat DD = new DecimalFormat("#####0.0################", LOC);
    public static final DecimalFormat SF = new DecimalFormat("0.0######E0", LOC);
    public static final DecimalFormat DF = new DecimalFormat("#####0.0######", LOC);
    public static final BigInteger MAX_ULONG = BigInteger.ONE.shiftLeft(64);
    public static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte MAX_HASH_LENGTH = 96;
    private static final int MAX_INT = 0xCCCCCCC;
    private static final long MAX_LONG = 0xCCCCCCCCCCCCCCCL;
    public static final byte[] HEX_TABLE = Token.token("0123456789ABCDEF");
    private static final byte[] IRI_CHARACTERS = Token.token("!#$%&*'()+,-./:;=?@[]~_");
    private static final byte[] URI_CHARACTERS = Token.token("-._~");
    private static final int[] CHLEN = new int[]{1, 1, 1, 1, 2, 2, 3, 4};
    private static final int[] INTSIZE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final float[] FLT = new float[]{1.0E17f, 1.0E15f, 1.0E13f, 1.0E11f, -1.0E17f, -1.0E15f, -1.0E13f, -1.0E11f};
    private static final byte[][] FLTSTR = Token.tokens("1.0E17", "1.0E15", "1.0E13", "1.0E11", "-1.0E17", "-1.0E15", "-1.0E13", "-1.0E11");

    private Token() {
    }

    public static String string(byte[] token) {
        return Token.string(token, 0, token.length);
    }

    public static String string(byte[] token, int start, int length) {
        if (length <= 0) {
            return "";
        }
        int e = start + length;
        for (int p = start; p < e; ++p) {
            if (token[p] >= 0) continue;
            return Token.utf8(token, start, length);
        }
        char[] str = new char[length];
        for (int p = 0; p < length; ++p) {
            str[p] = (char)token[start + p];
        }
        return new String(str);
    }

    private static String utf8(byte[] token, int start, int length) {
        StringBuilder sb = new StringBuilder(Array.newCapacity(length));
        int il = Math.min(start + length, token.length);
        for (int i = start; i < il; i += Token.cl(token, i)) {
            int cp = Token.cp(token, i);
            if (cp < 65536) {
                sb.append((char)cp);
                continue;
            }
            int o = cp - 65536;
            sb.append((char)((o >>> 10) + 55296));
            sb.append((char)((o & 0x3FF) + 56320));
        }
        return sb.toString();
    }

    public static boolean ascii(byte[] token) {
        for (byte b : token) {
            if (b >= 0) continue;
            return false;
        }
        return true;
    }

    public static byte[] token(String string) {
        int sl = string.length();
        if (sl == 0) {
            return EMPTY;
        }
        byte[] b = new byte[sl];
        for (int s = 0; s < sl; ++s) {
            char c = string.charAt(s);
            if (c > '\u007f') {
                return Token.utf8(string);
            }
            b[s] = (byte)c;
        }
        return b;
    }

    public static byte[][] tokens(String ... strings) {
        byte[][] tokens = new byte[strings.length][];
        int tl = tokens.length;
        for (int t = 0; t < tl; ++t) {
            tokens[t] = Token.token(strings[t]);
        }
        return tokens;
    }

    private static byte[] utf8(String string) {
        char[] arr = string.toCharArray();
        int al = arr.length;
        TokenBuilder tb = new TokenBuilder(Array.newCapacity(al));
        for (int c = 0; c < al; ++c) {
            int ch = arr[c];
            tb.add(Character.isHighSurrogate((char)ch) && c < al - 1 && Character.isLowSurrogate(arr[c + 1]) ? Character.toCodePoint((char)ch, arr[++c]) : ch);
        }
        return tb.finish();
    }

    public static byte[] token(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof ArrayOutput) {
            return ((ArrayOutput)object).toArray();
        }
        if (object instanceof TokenBuilder) {
            return ((TokenBuilder)object).toArray();
        }
        if (object instanceof Supplier) {
            return Token.token(((Supplier)object).get());
        }
        String s = object == null ? "null" : (object instanceof Throwable ? Util.message((Throwable)object) : (object instanceof Class ? Util.className((Class)object) : object.toString()));
        return Token.token(s);
    }

    public static int cp(byte[] token, int pos) {
        byte v = token[pos];
        if ((v & 0xFF) < 192) {
            return v & 0xFF;
        }
        int vl = Token.cl(v);
        if (pos + vl > token.length) {
            return 65533;
        }
        if (vl == 2) {
            return (v & 0x1F) << 6 | token[pos + 1] & 0x3F;
        }
        if (vl == 3) {
            return (v & 0xF) << 12 | (token[pos + 1] & 0x3F) << 6 | token[pos + 2] & 0x3F;
        }
        return (v & 7) << 18 | (token[pos + 1] & 0x3F) << 12 | (token[pos + 2] & 0x3F) << 6 | token[pos + 3] & 0x3F;
    }

    public static int cl(byte cp) {
        return cp >= 0 ? 1 : CHLEN[cp >> 4 & 7];
    }

    public static int cl(byte[] token, int pos) {
        return Token.cl(token[pos]);
    }

    public static int[] cps(byte[] token) {
        return Token.cps(token, Token.ascii(token));
    }

    public static int[] cps(byte[] token, boolean ascii) {
        int cl = token.length;
        int[] cps = new int[cl];
        if (ascii) {
            for (int c = 0; c < cl; ++c) {
                cps[c] = token[c];
            }
            return cps;
        }
        int pos = 0;
        for (int c = 0; c < cl; c += Token.cl(token, c)) {
            cps[pos++] = Token.cp(token, c);
        }
        return pos < cl ? Arrays.copyOf(cps, pos) : cps;
    }

    public static byte[] cpToken(int cp) {
        if (cp <= 127) {
            return new byte[]{(byte)cp};
        }
        if (cp <= 2047) {
            return new byte[]{(byte)(cp >> 6 & 0x1F | 0xC0), (byte)(cp & 0x3F | 0x80)};
        }
        if (cp <= 65535) {
            return new byte[]{(byte)(cp >> 12 & 0xF | 0xE0), (byte)(cp >> 6 & 0x3F | 0x80), (byte)(cp & 0x3F | 0x80)};
        }
        return new byte[]{(byte)(cp >> 18 & 7 | 0xF0), (byte)(cp >> 12 & 0x3F | 0x80), (byte)(cp >> 6 & 0x3F | 0x80), (byte)(cp & 0x3F | 0x80)};
    }

    public static int cpLength(int cp) {
        return cp <= 127 ? 1 : (cp <= 2047 ? 2 : (cp <= 65535 ? 3 : 4));
    }

    public static int length(byte[] token) {
        return Token.length(token, Token.ascii(token));
    }

    public static int length(byte[] token, boolean ascii) {
        int tl = token.length;
        if (ascii) {
            return tl;
        }
        int l = 0;
        for (int t = 0; t < tl; t += Token.cl(token, t)) {
            ++l;
        }
        return l;
    }

    public static byte[] token(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static byte[] token(int integer) {
        int q;
        boolean m;
        if (integer == 0) {
            return ZERO;
        }
        if (integer == Integer.MIN_VALUE) {
            return MIN_INT;
        }
        int n = integer;
        boolean bl = m = n < 0;
        if (m) {
            n = -n;
        }
        int nl = Token.numDigits(n);
        if (m) {
            ++nl;
        }
        byte[] num = new byte[nl];
        while (n > 81919) {
            q = n / 10;
            num[--nl] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        while (n != 0) {
            q = n * 52429 >>> 19;
            num[--nl] = (byte)(n - (q << 3) - (q << 1) + 48);
            n = q;
        }
        if (m) {
            num[--nl] = 45;
        }
        return num;
    }

    public static byte[] token(long value, int radix) {
        int shift = 1;
        int p = 2;
        while (shift < 6) {
            if (radix == p) {
                byte[] bytes = new byte[(64 + shift - 1) / shift];
                int mask = (1 << shift) - 1;
                long n = value;
                int pos = bytes.length;
                do {
                    bytes[--pos] = DIGITS[(int)(n & (long)mask)];
                } while ((n >>>= shift) != 0L);
                return Token.substring(bytes, pos);
            }
            ++shift;
            p <<= 1;
        }
        ByteList bl = new ByteList();
        long n = value;
        if (n < 0L) {
            BigInteger[] dr = BigInteger.valueOf(n).add(MAX_ULONG).divideAndRemainder(BigInteger.valueOf(radix));
            n = dr[0].longValue();
            bl.add(DIGITS[dr[1].intValue()]);
        } else {
            bl.add(DIGITS[(int)(n % (long)radix)]);
            n /= (long)radix;
        }
        while (n != 0L) {
            bl.add(DIGITS[(int)(n % (long)radix)]);
            n /= (long)radix;
        }
        return bl.reverse().finish();
    }

    public static int numDigits(int integer) {
        int i = 0;
        while (integer > INTSIZE[i]) {
            ++i;
        }
        return i + 1;
    }

    public static byte[] token(long integer) {
        return integer >= Integer.MIN_VALUE && integer <= Integer.MAX_VALUE ? Token.token((int)integer) : Token.token(Long.toString(integer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] token(double dbl) {
        String s;
        byte[] b = Token.tok(dbl);
        if (b != null) {
            return b;
        }
        double a = Math.abs(dbl);
        if (a >= 1.0E-6 && a < 1000000.0) {
            DecimalFormat decimalFormat = DD;
            synchronized (decimalFormat) {
                s = DD.format(dbl);
            }
        }
        DecimalFormat decimalFormat = SD;
        synchronized (decimalFormat) {
            s = SD.format(dbl);
        }
        return Token.chopNumber(Token.token(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] token(float flt) {
        String s1;
        DecimalFormat decimalFormat;
        boolean small;
        byte[] b = Token.tok(flt);
        if (b != null) {
            return b;
        }
        int fl = FLT.length;
        for (int i = 0; i < fl; ++i) {
            if (flt != FLT[i]) continue;
            return FLTSTR[i];
        }
        float a = Math.abs(flt);
        boolean bl = small = a >= 1.0E-6f && a < 1000000.0f;
        if (small) {
            decimalFormat = DF;
            synchronized (decimalFormat) {
                s1 = DF.format(flt);
            }
        }
        decimalFormat = SF;
        synchronized (decimalFormat) {
            s1 = SF.format(flt);
        }
        String s2 = Float.toString(flt);
        if (!(s2.length() >= s1.length() || s2.contains("E") && small)) {
            s1 = s2;
        }
        return Token.chopNumber(Token.token(s1));
    }

    private static byte[] tok(double value) {
        int i;
        if (value == Double.POSITIVE_INFINITY) {
            return INF;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATVE_INF;
        }
        if (value == 0.0) {
            return 1.0 / value > 0.0 ? ZERO : NEGATIVE_ZERO;
        }
        if (Double.isNaN(value)) {
            return NAN;
        }
        double a = Math.abs(value);
        if (a < 1000000.0 && (double)(i = (int)value) == value) {
            return Token.token(i);
        }
        return null;
    }

    public static byte[] chopNumber(byte[] token) {
        if (!Token.contains(token, 46) || Token.contains(token, 101) || Token.contains(token, 69)) {
            return token;
        }
        int l = token.length;
        while (--l > 0 && token[l] == 48) {
        }
        return Token.substring(token, 0, token[l] == 46 ? l : l + 1);
    }

    public static double toDouble(byte[] token) {
        int tl = token.length;
        int s = -1;
        while (++s < tl && Token.ws(token[s])) {
        }
        if (s == tl) {
            return Double.NaN;
        }
        int e = s;
        boolean f = false;
        for (int p = s; p < tl; ++p) {
            byte b = token[p];
            if (e == s) {
                if (Token.digit(b) || b == 43) continue;
                if (Token.ws(b)) {
                    e = p + 1;
                    continue;
                }
                boolean bl = f = b == 101 || b == 69 || b == 46 || b == 45;
                if (f) continue;
                return Double.NaN;
            }
            if (Token.ws(b)) continue;
            return Double.NaN;
        }
        if (e == s) {
            e = tl;
        }
        if (!f && e - s <= 9) {
            int d = Token.toInt(token, s, e);
            return d == Integer.MIN_VALUE ? Double.NaN : (double)d;
        }
        int l = e - s;
        if (l == 1) {
            return Double.NaN;
        }
        char[] str = new char[l];
        int sd = 0;
        int se = 0;
        for (int p = 0; p < l; ++p) {
            int b = token[s + p];
            if (b == 101 || b == 69) {
                b = p == 0 || p + 1 == l || ++se > 1 ? 0 : 101;
            } else if (b == 45) {
                if (p > 0 && (p + 1 == l || str[p - 1] != 'e')) {
                    b = 0;
                }
            } else if (b == 46 && (p > 0 && str[p - 1] == 'e' || ++sd > 1)) {
                b = 0;
            }
            if (b == 0) {
                return Double.NaN;
            }
            str[p] = b;
        }
        try {
            return Double.parseDouble(new String(str));
        }
        catch (NumberFormatException ex) {
            Util.debug(ex);
            return Double.NaN;
        }
    }

    public static long toLong(byte[] token) {
        return Token.toLong(token, 0, token.length);
    }

    public static long toLong(byte[] token, int start, int end) {
        byte b;
        int p;
        for (p = start; p < end && Token.ws(token[p]); ++p) {
        }
        if (p == end) {
            return Long.MIN_VALUE;
        }
        boolean m = false;
        if (token[p] == 45 || token[p] == 43) {
            boolean bl = m = token[p++] == 45;
        }
        if (p == end) {
            return Long.MIN_VALUE;
        }
        long v = 0L;
        while (p < end && (b = token[p]) >= 48 && b <= 57) {
            if (v >= 0xCCCCCCCCCCCCCCCL && (b > 55 || v > 0xCCCCCCCCCCCCCCCL)) {
                return Long.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + (long)b - 48L;
            ++p;
        }
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        return p < end ? Long.MIN_VALUE : (m ? -v : v);
    }

    public static int toInt(byte[] token) {
        return Token.toInt(token, 0, token.length);
    }

    private static int toInt(byte[] token, int start, int end) {
        byte b;
        int p;
        for (p = start; p < end && Token.ws(token[p]); ++p) {
        }
        if (p == end) {
            return Integer.MIN_VALUE;
        }
        boolean m = false;
        if (token[p] == 45 || token[p] == 43) {
            boolean bl = m = token[p++] == 45;
        }
        if (p == end) {
            return Integer.MIN_VALUE;
        }
        int v = 0;
        while (p < end && (b = token[p]) >= 48 && b <= 57) {
            if (v >= 0xCCCCCCC && (b > 55 || v > 0xCCCCCCC)) {
                return Integer.MIN_VALUE;
            }
            v = (v << 3) + (v << 1) + b - 48;
            ++p;
        }
        while (p < end && Token.ws(token[p])) {
            ++p;
        }
        return p < end || v < 0 ? Integer.MIN_VALUE : (m ? -v : v);
    }

    public static int hash(byte[] token) {
        int h = 0;
        int l = Math.min(token.length, 96);
        for (int i = 0; i != l; ++i) {
            h = (h << 5) - h + token[i];
        }
        return h;
    }

    public static boolean eq(byte[] token1, byte[] token2, Collation coll) {
        return coll != null ? coll.compare(token1, token2) == 0 : Token.eq(token1, token2);
    }

    public static boolean eq(byte[] token1, byte[] token2, DeepEqual deep) {
        Normalizer.Form form = deep.options.get(DeepEqualOptions.NORMALIZATION_FORM);
        byte[] t1 = Token.normalize(token1, form);
        byte[] t2 = Token.normalize(token2, form);
        if (deep.options.get(DeepEqualOptions.NORMALIZE_SPACE).booleanValue()) {
            t1 = Token.normalize(t1);
            t2 = Token.normalize(t2);
        }
        return Token.eq(t1, t2, deep.coll);
    }

    public static boolean eq(byte[] token1, byte[] token2) {
        return Arrays.equals(token1, token2);
    }

    public static boolean eq(byte[] token, byte[] ... tokens) {
        for (byte[] tok : tokens) {
            if (!Token.eq(token, tok)) continue;
            return true;
        }
        return false;
    }

    public static int diff(byte[] token, byte[] compare) {
        int tl = token.length;
        int cl = compare.length;
        int l = Math.min(tl, cl);
        for (int i = 0; i < l; ++i) {
            int c = (token[i] & 0xFF) - (compare[i] & 0xFF);
            if (c == 0) continue;
            return c;
        }
        return tl - cl;
    }

    public static int diff(byte[] token, byte[] compare, Collation coll) {
        return coll != null ? coll.compare(token, compare) : Token.diff(token, compare);
    }

    public static byte[] min(byte[] token, byte[] compare) {
        return Token.diff(token, compare) < 0 ? token : compare;
    }

    public static byte[] max(byte[] token, byte[] compare) {
        return Token.diff(token, compare) > 0 ? token : compare;
    }

    public static boolean contains(byte[] token, byte[] sub) {
        return Token.contains(token, sub, 0);
    }

    public static boolean contains(byte[] token, byte[] sub, int pos) {
        return Token.indexOf(token, sub, pos) != -1;
    }

    public static boolean contains(byte[] token, int ch) {
        return Token.indexOf(token, ch) != -1;
    }

    public static int indexOf(byte[] token, int ch) {
        return Token.indexOf(token, ch, 0);
    }

    public static int indexOf(byte[] token, int ch, int pos) {
        int tl = token.length;
        if (ch < 128) {
            for (int t = pos; t < tl; ++t) {
                if (token[t] != ch) continue;
                return t;
            }
        } else {
            for (int t = pos; t < tl; t += Token.cl(token, t)) {
                if (Token.cp(token, t) != ch) continue;
                return t;
            }
        }
        return -1;
    }

    public static int lastIndexOf(byte[] token, int ch) {
        int tl = token.length;
        int p = -1;
        if (ch < 128) {
            for (int t = tl - 1; t >= 0; --t) {
                if (token[t] != ch) continue;
                return t;
            }
        } else {
            for (int t = 0; t < tl; t += Token.cl(token, t)) {
                if (Token.cp(token, t) != ch) continue;
                p = t;
            }
        }
        return p;
    }

    public static int indexOf(byte[] token, byte[] sub) {
        return Token.indexOf(token, sub, 0);
    }

    public static int indexOf(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl == 0) {
            return pos;
        }
        int tl = token.length - sl;
        if (pos > tl) {
            return -1;
        }
        for (int t = pos; t <= tl; ++t) {
            int s = 0;
            while (sub[s] == token[t + s]) {
                if (++s != sl) continue;
                return t;
            }
        }
        return -1;
    }

    public static boolean startsWith(byte[] token, int ch) {
        return Token.startsWith(token, ch, 0);
    }

    private static boolean startsWith(byte[] token, int ch, int pos) {
        return pos < token.length && token[pos] == ch;
    }

    public static boolean startsWith(byte[] token, byte[] sub) {
        return Token.startsWith(token, sub, 0);
    }

    public static boolean startsWith(byte[] token, byte[] sub, int pos) {
        int sl = sub.length;
        if (sl > token.length - pos) {
            return false;
        }
        int s = 0;
        int p = pos;
        while (s < sl) {
            if (sub[s] != token[p]) {
                return false;
            }
            ++s;
            ++p;
        }
        return true;
    }

    public static boolean endsWith(byte[] token, int ch) {
        return token.length != 0 && token[token.length - 1] == ch;
    }

    public static boolean endsWith(byte[] token, byte[] sub) {
        int sl = sub.length;
        int tl = token.length;
        if (sl > tl) {
            return false;
        }
        for (int s = sl; s > 0; --s) {
            if (sub[sl - s] == token[tl - s]) continue;
            return false;
        }
        return true;
    }

    public static byte[] substring(byte[] token, int start) {
        return Token.substring(token, start, token.length);
    }

    public static byte[] substring(byte[] token, int start, int end) {
        int tl = token.length;
        int s = Math.max(0, start);
        int e = Math.min(end, tl);
        return s == 0 && e == tl ? token : (s < e ? Arrays.copyOfRange(token, s, e) : EMPTY);
    }

    public static byte[] subtoken(byte[] token, int start) {
        return Token.subtoken(token, start, token.length);
    }

    public static byte[] subtoken(byte[] token, int start, int end) {
        int t;
        int s = Math.max(0, start);
        int e = Math.min(end, token.length);
        if (s == 0 && e == token.length) {
            return token;
        }
        if (s >= e) {
            return EMPTY;
        }
        for (t = Math.max(0, s - 4); t != s && t < e; t += Token.cl(token, t)) {
            if (t < s) continue;
            s = t;
        }
        while (t < e) {
            t += Token.cl(token, t);
        }
        return Arrays.copyOfRange(token, s, t);
    }

    public static byte[][] split(byte[] token, int separator) {
        return Token.split(token, separator, false);
    }

    public static byte[][] split(byte[] token, int separator, boolean empty) {
        TokenList split = new TokenList();
        TokenBuilder tb = new TokenBuilder();
        int tl = token.length;
        for (int t = 0; t < tl; t += Token.cl(token, t)) {
            int c = Token.cp(token, t);
            if (c == separator) {
                if (!empty && tb.isEmpty()) continue;
                split.add(tb.next());
                continue;
            }
            tb.add(c);
        }
        if (empty || !tb.isEmpty()) {
            split.add(tb.finish());
        }
        return (byte[][])split.finish();
    }

    public static byte[][] distinctTokens(byte[] token) {
        byte[][] tokens = Token.split(Token.normalize(token), 32);
        int tl = tokens.length;
        for (int i = 0; i < tl - 1; ++i) {
            for (int j = i + 1; j < tl; ++j) {
                if (!Token.eq(tokens[i], tokens[j])) continue;
                Array.remove(tokens, j, 1, tl);
                --j;
                --tl;
            }
        }
        return Array.copyOf(tokens, tl);
    }

    public static boolean ws(byte[] token) {
        for (byte b : token) {
            if (Token.ws(b)) continue;
            return false;
        }
        return true;
    }

    public static byte[] replace(byte[] token, int search, int replace) {
        if (!Token.contains(token, search)) {
            return token;
        }
        TokenBuilder tb = new TokenBuilder(token.length);
        int tl = token.length;
        for (int i = 0; i < tl; i += Token.cl(token, i)) {
            int c = Token.cp(token, i);
            tb.add(c == search ? replace : c);
        }
        return tb.finish();
    }

    public static byte[] trim(byte[] token) {
        int s = -1;
        int e = token.length;
        while (++s < e && Token.ws(token[s])) {
        }
        while (--e > s && Token.ws(token[e])) {
        }
        if (++e == token.length && s == 0) {
            return token;
        }
        return s == e ? EMPTY : Arrays.copyOfRange(token, s, e);
    }

    public static byte[] chop(byte[] token, int max) {
        if (token.length <= max) {
            return token;
        }
        TokenBuilder tb = new TokenBuilder(max + 3);
        for (int t = 0; t < max; t += Token.cl(token, t)) {
            tb.add(Token.cp(token, t));
        }
        return tb.add(46).add(46).add(46).finish();
    }

    public static byte[] concat(byte[] ... tokens) {
        int sl = 0;
        for (byte[] token : tokens) {
            sl += token.length;
        }
        byte[] tmp = new byte[sl];
        int i = 0;
        for (byte[] token : tokens) {
            int tl = token.length;
            Array.copyFromStart(token, tl, tmp, i);
            i += tl;
        }
        return tmp;
    }

    public static byte[] concat(Object ... objects) {
        int ol = objects.length;
        byte[][] tokens = new byte[ol][];
        for (int o = 0; o < ol; ++o) {
            tokens[o] = Token.token(objects[o]);
        }
        return Token.concat(tokens);
    }

    public static byte[] delete(byte[] token, int ch) {
        if (ch < 128) {
            if (!Token.contains(token, ch)) {
                return token;
            }
            int tl = token.length;
            TokenBuilder tb = new TokenBuilder(tl);
            for (byte b : token) {
                if (b == ch) continue;
                tb.add(b);
            }
            return tb.finish();
        }
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        for (int i = 0; i < tl; i += Token.cl(token, i)) {
            int c = Token.cp(token, i);
            if (c == ch) continue;
            tb.add(c);
        }
        return tb.finish();
    }

    public static byte[] normalize(byte[] token) {
        int tl = token.length;
        if (tl == 0) {
            return token;
        }
        byte[] tmp = new byte[tl];
        int c = 0;
        boolean ws1 = true;
        for (int n : token) {
            boolean ws2 = Token.ws(n);
            if (ws2 && ws1) continue;
            tmp[c++] = ws2 ? 32 : n;
            ws1 = ws2;
        }
        if (c > 0 && Token.ws(tmp[c - 1])) {
            --c;
        }
        return c == tl ? tmp : Arrays.copyOf(tmp, c);
    }

    public static boolean ws(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch == 32;
    }

    public static boolean letter(int ch) {
        return ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95;
    }

    public static boolean digit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static boolean letterOrDigit(int ch) {
        return Token.letter(ch) || Token.digit(ch);
    }

    public static byte[] uc(byte[] token) {
        return Token.uc(token, Token.ascii(token));
    }

    public static byte[] uc(byte[] token, boolean ascii) {
        if (ascii) {
            int tl = token.length;
            byte[] tok = new byte[tl];
            for (int t = 0; t < tl; ++t) {
                tok[t] = (byte)Token.uc(token[t]);
            }
            return tok;
        }
        return Token.token(Token.string(token).toUpperCase(Locale.ENGLISH));
    }

    public static byte[] tc(byte[] token) {
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        boolean del = false;
        for (int t = 0; t < tl; t += Token.cl(token, t)) {
            int cp = Token.cp(token, t);
            tb.add(del ? Token.lc(cp) : Token.uc(cp));
            del = Character.isLetterOrDigit(cp);
        }
        return tb.finish();
    }

    public static int uc(int ch) {
        return ch >= 97 && ch <= 122 ? ch - 32 : (ch > 127 ? Character.toUpperCase(ch) : ch);
    }

    public static byte[] lc(byte[] token) {
        return Token.lc(token, Token.ascii(token));
    }

    public static byte[] lc(byte[] token, boolean ascii) {
        if (ascii) {
            int tl = token.length;
            byte[] tok = new byte[tl];
            for (int t = 0; t < tl; ++t) {
                tok[t] = (byte)Token.lc(token[t]);
            }
            return tok;
        }
        return Token.token(Token.string(token).toLowerCase(Locale.ENGLISH));
    }

    public static int lc(int ch) {
        return ch >= 65 && ch <= 90 ? ch | 0x20 : (ch > 127 ? Character.toLowerCase(ch) : ch);
    }

    public static byte[] prefix(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? EMPTY : Token.substring(name, 0, i);
    }

    public static byte[] local(byte[] name) {
        int i = Token.indexOf(name, 58);
        return i == -1 ? name : Token.substring(name, i + 1);
    }

    public static byte[] encodeUri(byte[] token, boolean iri) {
        TokenBuilder tb = new TokenBuilder();
        for (byte b : token) {
            if (Token.letterOrDigit(b) || Token.contains(iri ? IRI_CHARACTERS : URI_CHARACTERS, b)) {
                tb.addByte(b);
                continue;
            }
            Token.hex(tb, b);
        }
        return tb.finish();
    }

    public static byte[] escape(byte[] token) {
        TokenBuilder tb = new TokenBuilder();
        for (byte b : token) {
            if (b >= 32 && b <= 126) {
                tb.addByte(b);
                continue;
            }
            Token.hex(tb, b);
        }
        return tb.finish();
    }

    private static void hex(TokenBuilder tb, byte value) {
        tb.add(37);
        tb.addByte(HEX_TABLE[(value & 0xFF) >> 4]);
        tb.addByte(HEX_TABLE[value & 0xFF & 0xF]);
    }

    public static byte[] hex(byte[] value, boolean uc) {
        int vl = value.length;
        int u = uc ? 55 : 87;
        byte[] data = new byte[Array.checkCapacity((long)vl << 1)];
        int d = 0;
        for (int v = 0; v < vl; ++v) {
            byte a = value[v];
            int b = a >> 4 & 0xF;
            int c = a & 0xF;
            data[d++] = (byte)(b + (b > 9 ? u : 48));
            data[d++] = (byte)(c + (c > 9 ? u : 48));
        }
        return data;
    }

    public static int dec(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70) {
            return (ch & 0xF) + 9;
        }
        return -1;
    }

    public static int dec(int ch1, int ch2) {
        int n1 = Token.dec(ch1);
        int n2 = Token.dec(ch2);
        return n1 < 0 || n2 < 0 ? -1 : n1 << 4 | n2;
    }

    public static byte[] decodeUri(byte[] token, boolean plus) {
        int tl = token.length;
        TokenBuilder tb = new TokenBuilder(tl);
        for (int t = 0; t < tl; ++t) {
            byte b = token[t];
            if (plus && b == 43) {
                b = 32;
            } else if (b == 37) {
                int n;
                int n2 = n = t + 2 < tl ? Token.dec(token[t + 1], token[t + 2]) : -1;
                if (n < 0) {
                    return null;
                }
                b = (byte)n;
                t += 2;
            }
            tb.addByte(b);
        }
        return tb.finish();
    }

    public static byte[] normalize(byte[] token, Normalizer.Form form) {
        return Token.normalize(token, form, Token.ascii(token));
    }

    public static byte[] normalize(byte[] token, Normalizer.Form form, boolean ascii) {
        return form == null || ascii ? token : Token.token(Normalizer.normalize(Token.string(token), form));
    }
}

