/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.core.jobs.JobException;
import org.basex.io.out.PrintOutput;
import org.basex.io.out.ServerOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.util.Util;

public final class ServerQuery
extends Job {
    private final String query;
    private final Context ctx;
    private QueryProcessor qp;
    private boolean parsed;
    private final StringBuilder info = new StringBuilder();

    public ServerQuery(String query, Context ctx) {
        this.query = query;
        this.ctx = ctx;
    }

    public void bind(String name, Object value, String type) throws IOException {
        try {
            this.qp().variable(name, value, type);
        }
        catch (QueryException ex) {
            Util.stack(ex);
            throw new BaseXException(ex);
        }
    }

    public void context(Object value, String type) throws IOException {
        try {
            this.qp().context(value, type);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    public String info() {
        return this.info.toString();
    }

    public String parameters() throws IOException {
        this.parse();
        return this.qp.qc.parameters().toString();
    }

    public boolean updating() throws IOException {
        this.parse();
        return this.qp.updating;
    }

    public void execute(OutputStream out, boolean iterative, boolean encode, boolean full) throws IOException {
        try {
            this.parse();
            this.qp.register(this.ctx);
            QueryContext qc = this.qp.qc;
            QueryInfo qi = qc.info;
            this.qp.optimize();
            Iter iter = this.qp.iter();
            int hits = 0;
            PrintOutput po = PrintOutput.get(encode ? new ServerOutput(out) : out);
            SerializerOptions sopts = full ? SerializerMode.API.get() : qc.parameters();
            try (Serializer ser = Serializer.get(po, sopts);){
                Item item;
                while ((item = qc.next(iter)) != null) {
                    if (iterative) {
                        if (full) {
                            po.write(item.xdmInfo());
                        } else {
                            po.write(item.typeId().asByte());
                        }
                        ser.reset();
                        ser.serialize(item);
                        po.flush();
                        out.write(0);
                    } else {
                        ser.serialize(item);
                    }
                    ++hits;
                }
            }
            this.info.append(qi.toString(this.qp, po.size(), hits, this.jc().locks, true));
        }
        catch (JobException | QueryException ex) {
            throw new BaseXException(ex);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw new BaseXException(QueryError.BASEX_OVERFLOW.message, new Object[0]);
        }
        finally {
            if (this.qp != null) {
                if (this.parsed) {
                    this.qp.close();
                    this.qp.unregister(this.ctx);
                    this.parsed = false;
                }
                this.qp = null;
                this.popJob();
            }
        }
    }

    private void queryPlan() throws QueryIOException {
        if (this.ctx.options.get(MainOptions.XMLPLAN).booleanValue()) {
            this.info.append(Text.NL).append(Text.QUERY_PLAN).append(":").append(Text.NL);
            this.info.append(this.qp.toXml().serialize(SerializerMode.INDENT.get())).append(Text.NL);
        }
    }

    private void parse() throws IOException {
        if (this.parsed) {
            return;
        }
        try {
            this.qp().parse();
            this.qp.compile();
            this.queryPlan();
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
        this.parsed = true;
    }

    private QueryProcessor qp() {
        if (this.parsed || this.qp == null) {
            this.qp = this.pushJob(new QueryProcessor(this.query, this.ctx));
            this.parsed = false;
        }
        return this.qp;
    }
}

