/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import java.util.ArrayList;
import java.util.Iterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.var.StaticVar;
import org.basex.query.var.StaticVarRef;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class Variables
extends ExprInfo
implements Iterable<StaticVar> {
    private final QNmMap<VarEntry> vars = new QNmMap();

    public StaticVar declare(Var var, Expr expr, AnnList anns, String doc, boolean external, VarScope vs) throws QueryException {
        StaticVar sv = new StaticVar(var, expr, anns, doc, external, vs);
        this.varEntry(var.name).setVar(sv);
        return sv;
    }

    public void checkUp() throws QueryException {
        for (VarEntry ve : this.vars.values()) {
            ve.var.checkUp();
        }
    }

    public void check() throws QueryException {
        for (VarEntry ve : this.vars.values()) {
            if (ve.var != null) continue;
            StaticVarRef vr = ve.refs.get(0);
            throw QueryError.VARUNDEF_X.get(vr.info(), vr);
        }
    }

    public StaticVarRef newRef(QNm name, StaticContext sc, InputInfo ii) throws QueryException {
        StaticVarRef ref = new StaticVarRef(ii, name, sc);
        this.varEntry(name).addRef(ref);
        return ref;
    }

    private VarEntry varEntry(QNm name) {
        VarEntry entry = this.vars.get(name);
        if (entry == null) {
            entry = new VarEntry();
            this.vars.put(name, entry);
        }
        return entry;
    }

    public void bindExternal(QueryContext qc, QNmMap<Value> bindings) throws QueryException {
        for (QNm qnm : bindings) {
            VarEntry ve;
            if (qnm == QNm.EMPTY || (ve = this.vars.get(qnm)) == null) continue;
            ve.var.bind(bindings.get(qnm), qc);
        }
    }

    @Override
    public Iterator<StaticVar> iterator() {
        final Iterator<QNm> qnames = this.vars.iterator();
        return new Iterator<StaticVar>(){

            @Override
            public boolean hasNext() {
                return qnames.hasNext();
            }

            @Override
            public StaticVar next() {
                return Variables.this.vars.get((QNm)((QNm)qnames.next())).var;
            }

            @Override
            public void remove() {
                throw Util.notExpected();
            }
        };
    }

    @Override
    public void toXml(QueryPlan plan) {
        if (this.vars.isEmpty()) {
            return;
        }
        ArrayList<StaticVar> list = new ArrayList<StaticVar>(this.vars.size());
        for (VarEntry ve : this.vars.values()) {
            list.add(ve.var);
        }
        plan.add(plan.create(this, new Object[0]), list.toArray());
    }

    @Override
    public void toString(QueryString qs) {
        for (VarEntry ve : this.vars.values()) {
            qs.token(ve.var);
        }
    }

    private static class VarEntry {
        StaticVar var;
        final ArrayList<StaticVarRef> refs = new ArrayList(1);

        private VarEntry() {
        }

        void setVar(StaticVar vr) throws QueryException {
            if (this.var != null) {
                throw QueryError.VARDUPL_X.get(vr.info, new Object[]{this.var.name.string()});
            }
            this.var = vr;
            for (StaticVarRef ref : this.refs) {
                ref.init(this.var);
            }
        }

        void addRef(StaticVarRef ref) throws QueryException {
            this.refs.add(ref);
            if (this.var != null) {
                ref.init(this.var);
            }
        }
    }
}

