/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class StrSeq
extends NativeSeq {
    private final byte[][] values;

    private StrSeq(byte[][] values) {
        super(values.length, (Type)AtomType.STRING);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        byte[][] values = new byte[size][];
        for (int s = 0; s < size; ++s) {
            values[s] = in.readToken();
        }
        return StrSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (byte[] v : this.values) {
            out.writeToken(v);
        }
    }

    @Override
    public Str itemAt(long pos) {
        return Str.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        byte[][] array = new byte[sz][];
        for (int i = 0; i < sz; ++i) {
            array[sz - i - 1] = this.values[i];
        }
        return StrSeq.get(array);
    }

    public String[] toJava() {
        StringList sl = new StringList((int)this.size);
        for (byte[] value : this.values) {
            sl.add(value);
        }
        return (String[])sl.finish();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof StrSeq ? Array.equals(this.values, ((StrSeq)obj).values) : super.equals(obj));
    }

    public static Value get(TokenList values) {
        return values.isEmpty() ? Empty.VALUE : (values.size() == 1 ? Str.get((byte[])values.get(0)) : new StrSeq((byte[][])values.finish()));
    }

    public static Value get(byte[][] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Str.get(values[0]) : new StrSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        TokenList tmp = new TokenList(size);
        for (Value value : values) {
            if (value instanceof StrSeq) {
                tmp.add(((StrSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.string(null));
            }
        }
        return StrSeq.get(tmp);
    }
}

