/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.out.ArrayOutput;
import org.basex.io.out.DataOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.FnBaseUri;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.NodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    static final QNm XML_BASE = new QNm(QueryText.BASE, QueryText.XML_URI);
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOCUMENT_NODE, NodeType.ELEMENT, NodeType.TEXT, NodeType.ATTRIBUTE, NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION};
    private static final AtomicInteger ID = new AtomicInteger();
    public final int id = ID.incrementAndGet();

    ANode(NodeType type) {
        super(type);
    }

    @Override
    public final void write(DataOutput out) throws IOException {
        ArrayOutput ao = new ArrayOutput();
        Serializer.get(ao).serialize(this);
        out.writeToken(ao.finish());
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Item expr = this;
        if (mode == CompileContext.Simplify.STRING) {
            expr = Str.get(this.string());
        } else if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER)) {
            expr = Atm.get(this.string());
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return this.comparable(item) ? Token.eq(this.string(), item.string(ii), coll) : item.eq(this, coll, sc, ii);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        return this.comparable(item) ? Token.diff(this.string(), item.string(ii), coll) : -item.diff(this, coll, ii);
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        Type type1 = this.type;
        Type type2 = item.type;
        if (type1 != type2) {
            return false;
        }
        ANode node1 = this;
        ANode node2 = (ANode)item;
        if (node1.is(node2)) {
            return true;
        }
        QNm name1 = node1.qname();
        QNm name2 = node2.qname();
        if (type1 == NodeType.NAMESPACE_NODE) {
            return name1.eq(name2) && Token.eq(node1.string(), node2.string());
        }
        DeepEqualOptions options = deep.options;
        if (name1 != null && (!name1.eq(name2) || options.get(DeepEqualOptions.NAMESPACE_PREFIXES).booleanValue() && !Token.eq(name1.prefix(), name2.prefix()))) {
            return false;
        }
        if (type1.oneOf(NodeType.TEXT, NodeType.COMMENT, NodeType.PROCESSING_INSTRUCTION, NodeType.ATTRIBUTE) && !Token.eq(node1.string(), node2.string(), deep)) {
            return false;
        }
        if (options.get(DeepEqualOptions.BASE_URI).booleanValue()) {
            if (deep.nested) {
                return Token.eq(node1.baseURI(), node2.baseURI());
            }
            Uri uri1 = FnBaseUri.uri(node1, Uri.EMPTY, deep.info);
            Uri uri2 = FnBaseUri.uri(node2, Uri.EMPTY, deep.info);
            if (uri1 == null ? uri2 != null : uri2 == null || !uri1.eq(uri2)) {
                return false;
            }
        }
        if (type1 == NodeType.ELEMENT) {
            ANode attr1;
            BasicNodeIter iter1 = node1.attributeIter();
            BasicNodeIter iter2 = node2.attributeIter();
            if (iter1.size() != iter2.size()) {
                return false;
            }
            while ((attr1 = iter1.next()) != null) {
                ANode attr2;
                name1 = attr1.qname();
                do {
                    if ((attr2 = iter2.next()) != null) continue;
                    return false;
                } while (!name1.eq(name2 = attr2.qname()));
                if (options.get(DeepEqualOptions.NAMESPACE_PREFIXES).booleanValue() && !Token.eq(name1.prefix(), name2.prefix()) || !Token.eq(attr1.string(), attr2.string(), deep)) {
                    return false;
                }
                iter2 = node2.attributeIter();
            }
            if (options.get(DeepEqualOptions.IN_SCOPE_NAMESPACES).booleanValue()) {
                Atts atts2;
                Atts atts1 = deep.nested ? node1.namespaces() : node1.nsScope(null);
                Atts atts = atts2 = deep.nested ? node2.namespaces() : node2.nsScope(null);
                if (!atts1.equals(atts2)) {
                    return false;
                }
            }
        } else if (type1 != NodeType.DOCUMENT_NODE) {
            return true;
        }
        Function<ANode, ANodeList> children = node -> {
            ANodeList nl = new ANodeList();
            for (ANode child : node.childIter()) {
                Type tp;
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if ((tp = child.type) == NodeType.COMMENT && !options.get(DeepEqualOptions.COMMENTS).booleanValue() || tp == NodeType.PROCESSING_INSTRUCTION && !options.get(DeepEqualOptions.PROCESSING_INSTRUCTIONS).booleanValue()) continue;
                if (tp == NodeType.TEXT) {
                    byte[] string = child.string();
                    if (Token.ws(string) && !options.get(DeepEqualOptions.PRESERVE_SPACE).booleanValue()) continue;
                    if (!nl.isEmpty() && ((ANode)nl.peek()).type == NodeType.TEXT && !options.get(DeepEqualOptions.TEXT_BOUNDARIES).booleanValue()) {
                        nl.add(new FTxt(Token.concat(((ANode)nl.pop()).string(), string)));
                        continue;
                    }
                }
                nl.add(child.finish());
            }
            return nl;
        };
        ANodeList list1 = children.apply(node1);
        ANodeList list2 = children.apply(node2);
        int size1 = list1.size();
        if (size1 != list2.size()) {
            return false;
        }
        deep.nested = true;
        if (name1 == null || !options.unordered(name1)) {
            ANode child1;
            BasicNodeIter iter1 = list1.iter();
            BasicNodeIter iter2 = list2.iter();
            do {
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if ((child1 = ((NodeIter)iter1).next()) != null) continue;
                return true;
            } while (child1.deepEqual(((NodeIter)iter2).next(), deep));
            return false;
        }
        for (int l1 = size1 - 1; l1 >= 0; --l1) {
            boolean found = false;
            for (int l2 = list2.size() - 1; !found && l2 >= 0; --l2) {
                if (deep.qc != null) {
                    deep.qc.checkStop();
                }
                if (!((ANode)list1.get(l1)).deepEqual((Item)list2.get(l2), deep)) continue;
                list2.remove(l2);
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Item atomValue(QueryContext qc, InputInfo ii) {
        return this.atomItem(qc, ii);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) {
        return this.type.oneOf(NodeType.PROCESSING_INSTRUCTION, NodeType.COMMENT) ? Str.get(this.string()) : Atm.get(this.string());
    }

    @Override
    public abstract ANode materialize(Predicate<Data> var1, InputInfo var2, QueryContext var3) throws QueryException;

    @Override
    public final boolean materialized(Predicate<Data> test, InputInfo ii) {
        return test.test(this.data());
    }

    public final DBNode copy(QueryContext qc) throws QueryException {
        return this.copy(qc.context.options, qc);
    }

    public final DBNode copy(MainOptions options, QueryContext qc) throws QueryException {
        MemData data = new MemData(options);
        new DataBuilder(data, qc).build(this);
        return new DBNode(data);
    }

    public abstract ANode finish();

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope(StaticContext sc) {
        Atts ns = new Atts();
        ANode node = this;
        do {
            Atts nsp;
            if ((nsp = node.namespaces()) == null) continue;
            for (int a = nsp.size() - 1; a >= 0; --a) {
                byte[] key = nsp.name(a);
                if (ns.contains(key)) continue;
                ns.add(key, nsp.value(a));
            }
        } while ((node = node.parent()) != null && node.type == NodeType.ELEMENT);
        if (sc != null) {
            sc.ns.inScope(ns);
        }
        return ns;
    }

    public final byte[] uri(byte[] prefix) {
        Atts ns = this.namespaces();
        if (ns != null) {
            byte[] s = ns.value(prefix);
            if (s != null) {
                return s;
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(prefix);
            }
        }
        return (byte[])(prefix.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    static int diff(ANode node1, ANode node2) {
        ANodeList nl = new ANodeList();
        for (ANode n = node1; n != null; n = n.parent()) {
            if (n == node2) {
                return 1;
            }
            nl.add(n);
        }
        ANode c2 = node2;
        ANode n = node2;
        block1: while ((n = n.parent()) != null) {
            int is = nl.size();
            for (int i = 1; i < is; ++i) {
                if (n == node1) {
                    return -1;
                }
                if (!((ANode)nl.get(i)).is(n)) continue;
                ANode c1 = (ANode)nl.get(i - 1);
                for (ANode c : n.childIter()) {
                    if (c.is(c1)) {
                        return -1;
                    }
                    if (!c.is(c2)) continue;
                    return 1;
                }
                break block1;
            }
            c2 = n;
        }
        return node1.id - node2.id;
    }

    public final ANode root() {
        ANode p = this.parent();
        return p == null ? this : p.root();
    }

    public abstract ANode parent();

    public abstract void parent(FNode var1);

    public abstract boolean hasChildren();

    public final byte[] attribute(QNm name) {
        ANode node;
        BasicNodeIter iter = this.attributeIter();
        do {
            if ((node = iter.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public BasicNodeIter ancestorIter() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = ANode.this;
            }

            @Override
            public ANode next() {
                this.node = this.node.parent();
                return this.node;
            }
        };
    }

    public BasicNodeIter ancestorOrSelfIter() {
        return new BasicNodeIter(){
            private ANode node;
            {
                this.node = ANode.this;
            }

            @Override
            public ANode next() {
                if (this.node == null) {
                    return null;
                }
                ANode n = this.node;
                this.node = n.parent();
                return n;
            }
        };
    }

    public abstract BasicNodeIter attributeIter();

    public abstract BasicNodeIter childIter();

    public abstract BasicNodeIter descendantIter();

    public abstract BasicNodeIter descendantOrSelfIter();

    public BasicNodeIter followingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        BasicNodeIter ir = root.childIter();
                        if (node.type != NodeType.ATTRIBUTE) {
                            for (ANode nd : ir) {
                                if (nd.is(node)) break;
                            }
                        }
                        for (ANode nd : ir) {
                            list.add(nd.finish());
                            ANode.addDesc(nd.childIter(), list);
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public BasicNodeIter followingSiblingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANode n;
                    ANode root = ANode.this.parent();
                    if (root == null) {
                        return null;
                    }
                    this.iter = root.childIter();
                    while ((n = this.iter.next()) != null && !n.is(ANode.this)) {
                    }
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter parentIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this.parent();
            }
        };
    }

    public final BasicNodeIter precedingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode node = ANode.this;
                    for (ANode root = node.parent(); root != null; root = root.parent()) {
                        if (node.type != NodeType.ATTRIBUTE) {
                            ANodeList tmp = new ANodeList();
                            for (ANode c : root.childIter()) {
                                if (c.is(node)) break;
                                tmp.add(c.finish());
                                ANode.addDesc(c.childIter(), tmp);
                            }
                            for (int t = tmp.size() - 1; t >= 0; --t) {
                                list.add((ANode)tmp.get(t));
                            }
                        }
                        node = root;
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter precedingSiblingIter() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;
            private int i;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    if (ANode.this.type == NodeType.ATTRIBUTE) {
                        return null;
                    }
                    ANode root = ANode.this.parent();
                    if (root == null) {
                        return null;
                    }
                    ANodeList list = new ANodeList();
                    for (ANode node : root.childIter()) {
                        if (node.is(ANode.this)) break;
                        list.add(node.finish());
                    }
                    this.i = list.size();
                    this.iter = list.iter();
                }
                return this.i > 0 ? this.iter.get(--this.i) : null;
            }
        };
    }

    public final BasicNodeIter selfIter() {
        return new BasicNodeIter(){
            private boolean called;

            @Override
            public ANode next() {
                if (this.called) {
                    return null;
                }
                this.called = true;
                return ANode.this;
            }
        };
    }

    private static void addDesc(BasicNodeIter children, ANodeList nodes) {
        for (ANode node : children) {
            nodes.add(node.finish());
            ANode.addDesc(node.childIter(), nodes);
        }
    }

    public int kind() {
        return ANode.kind((NodeType)this.type);
    }

    public static int kind(NodeType type) {
        switch (type) {
            case DOCUMENT_NODE: {
                return 0;
            }
            case ELEMENT: {
                return 1;
            }
            case TEXT: {
                return 2;
            }
            case ATTRIBUTE: {
                return 3;
            }
            case COMMENT: {
                return 4;
            }
            case PROCESSING_INSTRUCTION: {
                return 5;
            }
        }
        return -1;
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public abstract BXNode toJava() throws QueryException;
}

