/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.query.QueryBiConsumer;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.MergeDuplicates;
import org.basex.query.value.map.TrieBranch;
import org.basex.query.value.map.TrieList;
import org.basex.query.value.map.TrieNode;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;

final class TrieLeaf
extends TrieNode {
    final int hash;
    final Item key;
    final Value value;

    TrieLeaf(int hash, Item key, Value value) {
        super(1);
        this.hash = hash;
        this.key = key;
        this.value = value;
        assert (this.verify());
    }

    @Override
    TrieNode put(int hs, Item ky, Value vl, int level, InputInfo ii) throws QueryException {
        int used;
        int b;
        if (hs == this.hash) {
            return this.key.atomicEqual(ky, ii) ? new TrieLeaf(hs, ky, vl) : new TrieList(this.hash, this.key, this.value, ky, vl);
        }
        TrieNode[] ch = new TrieNode[32];
        int a = TrieLeaf.key(hs, level);
        if (a == (b = TrieLeaf.key(this.hash, level))) {
            ch[a] = this.put(hs, ky, vl, level + 1, ii);
            used = 1 << a;
        } else {
            ch[a] = new TrieLeaf(hs, ky, vl);
            ch[b] = this;
            used = 1 << a | 1 << b;
        }
        return new TrieBranch(ch, used, 2);
    }

    @Override
    TrieNode delete(int hs, Item ky, int level, InputInfo ii) throws QueryException {
        return hs == this.hash && this.key.atomicEqual(ky, ii) ? null : this;
    }

    @Override
    Value get(int hs, Item ky, int level, InputInfo ii) throws QueryException {
        return hs == this.hash && this.key.atomicEqual(ky, ii) ? this.value : null;
    }

    @Override
    boolean contains(int hs, Item ky, int level, InputInfo ii) throws QueryException {
        return hs == this.hash && this.key.atomicEqual(ky, ii);
    }

    @Override
    TrieNode addAll(TrieNode node, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        return node.add(this, level, merge, qc, ii);
    }

    @Override
    TrieNode add(TrieLeaf leaf, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        qc.checkStop();
        if (this.hash == leaf.hash) {
            if (!this.key.atomicEqual(leaf.key, ii)) {
                return new TrieList(this.hash, this.key, this.value, leaf.key, leaf.value);
            }
            switch (merge) {
                case USE_FIRST: 
                case USE_ANY: {
                    return leaf;
                }
                case USE_LAST: {
                    return this;
                }
                case COMBINE: {
                    return new TrieLeaf(this.hash, this.key, ValueBuilder.concat(leaf.value, this.value, qc));
                }
            }
            throw QueryError.MERGE_DUPLICATE_X.get(ii, this.key);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieLeaf.key(this.hash, level);
        if (k == (ok = TrieLeaf.key(leaf.hash, level))) {
            ch[k] = this.add(leaf, level + 1, merge, qc, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = leaf;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, 2);
    }

    @Override
    TrieNode add(TrieList list, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        if (this.hash == list.hash) {
            for (int i = 0; i < list.size; ++i) {
                if (!this.key.atomicEqual(list.keys[i], ii)) continue;
                Item[] ks = (Item[])list.keys.clone();
                Value[] vs = (Value[])list.values.clone();
                ks[i] = this.key;
                switch (merge) {
                    case USE_FIRST: 
                    case USE_ANY: {
                        break;
                    }
                    case USE_LAST: {
                        vs[i] = this.value;
                        break;
                    }
                    case COMBINE: {
                        vs[i] = ValueBuilder.concat(list.values[i], this.value, qc);
                        break;
                    }
                    default: {
                        throw QueryError.MERGE_DUPLICATE_X.get(ii, this.key);
                    }
                }
                return new TrieList(this.hash, ks, vs);
            }
            return new TrieList(this.hash, Array.add(list.keys, this.key), Array.add(list.values, this.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = TrieLeaf.key(this.hash, level);
        if (k == (ok = TrieLeaf.key(list.hash, level))) {
            ch[k] = this.add(list, level + 1, merge, qc, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = list;
            nu = 1 << k | 1 << ok;
        }
        return new TrieBranch(ch, nu, list.size + 1);
    }

    @Override
    TrieNode add(TrieBranch branch, int level, MergeDuplicates merge, QueryContext qc, InputInfo ii) throws QueryException {
        int k = TrieLeaf.key(this.hash, level);
        TrieNode[] ch = branch.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, level + 1, merge, qc, ii);
        ch[k] = trieNode;
        return new TrieBranch(ch, branch.used | 1 << k, branch.size + ch[k].size - (old != null ? old.size : 0));
    }

    @Override
    boolean verify() {
        try {
            return this.key.hash(null) == this.hash;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            return false;
        }
    }

    @Override
    void keys(ItemList keys) {
        keys.add(this.key);
    }

    @Override
    void values(ValueBuilder vs) {
        vs.add(this.value);
    }

    @Override
    void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.key.cache(lazy, ii);
        this.value.cache(lazy, ii);
    }

    @Override
    boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        return this.value.materialized(test, ii);
    }

    @Override
    void apply(QueryBiConsumer<Item, Value> func) throws QueryException {
        func.accept(this.key, this.value);
    }

    @Override
    boolean instanceOf(AtomType kt, SeqType dt) {
        return !(kt != null && !this.key.type.instanceOf(kt) || dt != null && !dt.instance(this.value));
    }

    @Override
    boolean equal(TrieNode node, DeepEqual deep) throws QueryException {
        return node instanceof TrieLeaf && this.key.atomicEqual(((TrieLeaf)node).key, deep.info) && deep.equal(this.value, ((TrieLeaf)node).value);
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        return 31 * this.hash + this.value.hash(ii);
    }

    @Override
    StringBuilder append(StringBuilder sb, String indent) {
        return sb.append(indent).append("`-- ").append(this.key).append(" => ").append(this.value).append('\n');
    }

    @Override
    StringBuilder append(StringBuilder sb) {
        if (TrieLeaf.more(sb)) {
            sb.append(this.key).append(": ").append(this.value).append(", ");
        }
        return sb;
    }
}

