/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.net.URI;
import java.net.URISyntaxException;
import org.basex.query.CompileContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.util.UriParser;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Uri
extends AStr {
    public static final Uri EMPTY = new Uri(Token.EMPTY);
    private UriParser.ParsedUri parsed;

    private Uri(byte[] value) {
        super(value, AtomType.ANY_URI);
    }

    public static Uri get(byte[] value) {
        return Uri.get(value, true);
    }

    public static Uri get(String value) {
        return Uri.get(Token.token(value), true);
    }

    public static Uri get(byte[] value, boolean normalize) {
        byte[] uri = normalize ? Token.normalize(value) : value;
        return uri.length == 0 ? EMPTY : new Uri(uri);
    }

    public boolean eq(Uri uri) {
        return Token.eq(this.string(), uri.string());
    }

    public Uri resolve(Uri add, InputInfo ii) throws QueryException {
        if (add.value.length == 0) {
            return this;
        }
        try {
            URI base = new URI(Token.string(this.value));
            URI res = new URI(Token.string(add.value));
            String uri = base.resolve(res).toString();
            if (uri.startsWith("file:/")) {
                uri = uri.replaceAll("^file:/([^/])", "file:///$1");
            }
            return Uri.get(Token.token(uri), false);
        }
        catch (URISyntaxException ex) {
            throw QueryError.URIARG_X.get(ii, ex.getMessage());
        }
    }

    public boolean isAbsolute() {
        return this.parsed().absolute();
    }

    public boolean isValid() {
        return this.parsed().valid();
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.value;
    }

    public byte[] string() {
        return this.value;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? Bln.get(this.value.length != 0) : this, mode);
    }

    private UriParser.ParsedUri parsed() {
        if (this.parsed == null) {
            this.parsed = UriParser.parse(Token.string(Token.encodeUri(this.value, true)));
        }
        return this.parsed;
    }

    @Override
    public URI toJava() throws QueryException {
        try {
            return new URI(Token.string(this.value));
        }
        catch (URISyntaxException ex) {
            throw new QueryException(ex);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Uri)) {
            return false;
        }
        Uri u = (Uri)obj;
        return this.type == u.type && Token.eq(this.value, u.value);
    }
}

