/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.CompileContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class Atm
extends Item {
    public static final Atm EMPTY = new Atm(Token.EMPTY);
    private final byte[] value;

    private Atm(byte[] value) {
        super(AtomType.UNTYPED_ATOMIC);
        this.value = value;
    }

    public static Atm get(String value) {
        return Atm.get(Token.token(value));
    }

    public static Atm get(byte[] value) {
        return value.length == 0 ? EMPTY : new Atm(value);
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.value;
    }

    @Override
    public boolean bool(InputInfo ii) {
        return this.value.length != 0;
    }

    @Override
    public boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        return this.comparable(item) ? Token.eq(this.value, item.string(ii), coll) : item.eq(this, coll, sc, ii);
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.comparable(item) && Token.eq(this.string(deep.info), item.string(deep.info), deep);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        return item.type.isUntyped() ? Token.diff(this.value, item.string(ii), coll) : -item.diff(this, coll, ii);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode.oneOf(CompileContext.Simplify.EBV, CompileContext.Simplify.PREDICATE) ? Bln.get(this != EMPTY) : this, mode);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Atm && Token.eq(this.value, ((Atm)obj).value);
    }

    @Override
    public String toJava() {
        return Token.string(this.value);
    }

    @Override
    public void toString(QueryString qs) {
        qs.quoted(this.value);
    }
}

