/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public abstract class ANum
extends Item {
    ANum(Type type) {
        super(type);
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    @Override
    public final double dbl(InputInfo ii) {
        return this.dbl();
    }

    @Override
    public final long itr(InputInfo ii) {
        return this.itr();
    }

    @Override
    public final float flt(InputInfo ii) {
        return this.flt();
    }

    @Override
    public boolean atomicEqual(Item item, InputInfo ii) throws QueryException {
        if (item instanceof ANum) {
            double d1 = this.dbl(ii);
            double d2 = item.dbl(ii);
            boolean n1 = Double.isNaN(d1);
            boolean n2 = Double.isNaN(d2);
            if (n1 || n2) {
                return n1 == n2;
            }
            if (Double.isInfinite(d1) || Double.isInfinite(d2)) {
                return d1 == d2;
            }
            return this.dec(ii).compareTo(item.dec(ii)) == 0;
        }
        return false;
    }

    protected abstract byte[] string();

    public abstract long itr();

    public abstract double dbl();

    protected abstract float flt();

    public abstract ANum abs();

    public abstract ANum ceiling();

    public abstract ANum floor();

    public abstract ANum round(int var1, boolean var2);

    @Override
    public final boolean comparable(Item item) {
        return item instanceof ANum;
    }

    @Override
    public Item test(QueryContext qc, InputInfo ii) {
        return this.dbl() == (double)qc.focus.pos ? this : null;
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        double d = this.dbl();
        return cc.simplify(this, mode == CompileContext.Simplify.PREDICATE && (d != (double)this.itr() || d < 1.0) || mode == CompileContext.Simplify.EBV && d == 0.0 ? Bln.FALSE : this, mode);
    }

    @Override
    public final Expr optimizePos(CmpV.OpV op, CompileContext cc) {
        long l;
        double d = this.dbl();
        boolean fractional = d != (double)(l = (long)d);
        switch (op) {
            case EQ: {
                if (!(d < 1.0) && !fractional) break;
                return Bln.FALSE;
            }
            case LE: {
                if (!(d < 1.0)) break;
                return Bln.FALSE;
            }
            case NE: {
                if (!(d < 1.0) && !fractional) break;
                return Bln.TRUE;
            }
            case GT: {
                if (!(d < 1.0)) break;
                return Bln.TRUE;
            }
            case LT: {
                if (!(d < Math.nextUp(1.0))) break;
                return Bln.FALSE;
            }
            case GE: {
                if (!(d < Math.nextUp(1.0))) break;
                return Bln.TRUE;
            }
        }
        return fractional || this instanceof Int ? this : Int.get(l);
    }

    @Override
    public final int hash(InputInfo ii) {
        long l = this.itr();
        float f = this.flt(ii);
        int frac = f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY || Float.isNaN(f) ? 0 : Float.floatToIntBits(f - (float)l);
        int h = frac ^ (int)(l ^ l >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    @Override
    public final void toString(QueryString qs) {
        qs.token(this.string(null));
    }
}

