/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.basex.core.Store;
import org.basex.data.Data;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.EmptyArray;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQData;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.BoolList;
import org.basex.util.list.ByteList;
import org.basex.util.list.DoubleList;
import org.basex.util.list.ElementList;
import org.basex.util.list.FloatList;
import org.basex.util.list.IntList;
import org.basex.util.list.LongList;
import org.basex.util.list.ObjectList;
import org.basex.util.list.ShortList;
import org.basex.util.list.StringList;

public abstract class XQArray
extends XQData {
    static final int MIN_LEAF = 8;
    static final int MAX_LEAF = 15;
    static final int MIN_DIGIT = 4;
    static final int MAX_DIGIT = 19;
    static final int MAX_SMALL = 7;
    private Iterable<Value> iterable;

    XQArray(Type type) {
        super(type);
    }

    public static XQArray empty() {
        return EmptyArray.EMPTY;
    }

    public static XQArray member(Value value) {
        return new SmallArray(new Value[]{value}, ArrayType.get(value.seqType()));
    }

    public abstract XQArray cons(Value var1);

    public abstract XQArray snoc(Value var1);

    public abstract Value get(long var1);

    public abstract XQArray put(long var1, Value var3);

    public abstract long arraySize();

    public abstract XQArray concat(XQArray var1);

    public abstract Value head();

    public abstract Value last();

    public abstract XQArray init();

    public abstract XQArray tail();

    public abstract XQArray subArray(long var1, long var3, QueryContext var5);

    public abstract XQArray reverseArray(QueryContext var1);

    public abstract boolean isEmptyArray();

    public abstract XQArray insertBefore(long var1, Value var3, QueryContext var4);

    public abstract XQArray remove(long var1, QueryContext var3);

    @Override
    public void write(DataOutput out) throws IOException, QueryException {
        out.writeLong(this.arraySize());
        for (Value member : this.members()) {
            Store.write(out, member);
        }
    }

    @Override
    public final void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Value value : this.members()) {
            value.cache(lazy, ii);
        }
    }

    public abstract ListIterator<Value> iterator(long var1);

    public final Iterable<Value> members() {
        if (this.iterable == null) {
            this.iterable = () -> this.iterator(0L);
        }
        return this.iterable;
    }

    abstract XQArray prepend(SmallArray var1);

    static Value[] slice(Value[] values, int from, int to) {
        Value[] out = new Value[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, values.length);
        int out0 = Math.max(-from, 0);
        Array.copy(values, in0, in1 - in0, out, out0);
        return out;
    }

    static Value[] concat(Value[] values1, Value[] values2) {
        int l = values1.length;
        int r = values2.length;
        int n = l + r;
        Value[] out = new Value[n];
        Array.copy(values1, l, out);
        Array.copyFromStart(values2, r, out, l);
        return out;
    }

    final Type union(Value value) {
        SeqType dt = ((ArrayType)this.type).declType;
        SeqType st = value.seqType();
        return dt.eq(st) ? this.type : ArrayType.get(dt.union(st));
    }

    abstract void checkInvariants();

    @Override
    public final Value get(Item key, InputInfo ii) throws QueryException {
        Type tp = key.type;
        if (!tp.instanceOf(AtomType.INTEGER) && !tp.isUntyped()) {
            throw QueryError.typeError(key, AtomType.INTEGER, ii);
        }
        long pos = key.itr(ii);
        long size = this.arraySize();
        if (pos > 0L && pos <= size) {
            return this.get(pos - 1L);
        }
        throw (size == 0L ? QueryError.ARRAYEMPTY : QueryError.ARRAYBOUNDS_X_X).get(ii, pos, size);
    }

    @Override
    public final QNm paramName(int pos) {
        return new QNm("pos", "");
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        if (this.arraySize() == 1L) {
            return this.get(0L).atomValue(qc, ii);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value value : this.members()) {
            vb.add(value.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.atomValue(qc, ii).item(qc, ii);
    }

    @Override
    public final void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add(91);
        int c = 0;
        for (Value value : this.members()) {
            long vs;
            if (c++ > 0) {
                tb.add(44);
                if (indent) {
                    tb.add(32);
                }
            }
            if ((vs = value.size()) != 1L) {
                tb.add(40);
            }
            int cc = 0;
            int i = 0;
            while ((long)i < vs) {
                Item item;
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if ((item = value.itemAt(i)) instanceof XQArray) {
                    ((XQArray)item).string(indent, tb, level, ii);
                } else if (item instanceof XQMap) {
                    ((XQMap)item).string(indent, tb, level + 1, ii);
                } else {
                    tb.add(item.toString());
                }
                ++i;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        tb.add(93);
    }

    @Override
    public Item materialize(Predicate<Data> test, InputInfo ii, QueryContext qc) throws QueryException {
        if (this.materialized(test, ii)) {
            return this;
        }
        ArrayBuilder ab = new ArrayBuilder();
        for (Value value : this.members()) {
            qc.checkStop();
            ab.append(value.materialize(test, ii, qc));
        }
        return ab.array(this);
    }

    @Override
    public boolean materialized(Predicate<Data> test, InputInfo ii) throws QueryException {
        if (!this.funcType().declType.type.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
            for (Value value : this.members()) {
                if (value.materialized(test, ii)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean instanceOf(Type tp) {
        if (this.type.instanceOf(tp)) {
            return true;
        }
        if (!(tp instanceof FuncType) || tp instanceof MapType) {
            return false;
        }
        FuncType ft = (FuncType)tp;
        if (ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(SeqType.INTEGER_O)) {
            return false;
        }
        SeqType dt = ft.declType;
        if (dt.eq(SeqType.ITEM_ZM)) {
            return true;
        }
        for (Value value : this.members()) {
            if (dt.instance(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        if (item instanceof FuncItem) {
            throw QueryError.FICOMPARE_X.get(deep.info, item);
        }
        if (item instanceof XQArray) {
            XQArray array = (XQArray)item;
            if (this.arraySize() != array.arraySize()) {
                return false;
            }
            ListIterator<Value> iter1 = this.iterator(0L);
            ListIterator<Value> iter2 = array.iterator(0L);
            while (iter1.hasNext()) {
                if (deep.equal((Value)iter1.next(), (Value)iter2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public final Object toJava() throws QueryException {
        int sz = (int)this.arraySize();
        Object dt = this.funcType().declType;
        if (sz > 0 && ((SeqType)dt).eq(SeqType.ITEM_ZM)) {
            dt = null;
            for (Value member : this.members()) {
                Iterator<Value> st = member.seqType();
                dt = dt == null ? st : ((SeqType)dt).union((SeqType)((Object)st));
            }
        }
        if (((SeqType)dt).one()) {
            ElementList list;
            Type t = ((SeqType)dt).type;
            if (t == AtomType.BOOLEAN) {
                list = new BoolList(sz);
                for (Value member : this.members()) {
                    ((BoolList)list).add(((Bln)member).bool(null));
                }
                return ((BoolList)list).finish();
            }
            if (t == AtomType.BYTE) {
                list = new ByteList(sz);
                for (Value member : this.members()) {
                    ((ByteList)list).add((byte)((Int)member).itr());
                }
                return ((ByteList)list).finish();
            }
            if (t.oneOf(AtomType.SHORT, AtomType.UNSIGNED_BYTE)) {
                list = new ShortList(sz);
                for (Value member : this.members()) {
                    ((ShortList)list).add((short)((Int)member).itr());
                }
                return ((ShortList)list).finish();
            }
            if (t == AtomType.UNSIGNED_SHORT) {
                char[] chars = new char[sz];
                int c = 0;
                for (Value member : this.members()) {
                    chars[c++] = (char)((Int)member).itr();
                }
                return chars;
            }
            if (t == AtomType.INT) {
                list = new IntList(sz);
                for (Value member : this.members()) {
                    ((IntList)list).add((int)((Int)member).itr());
                }
                return ((IntList)list).finish();
            }
            if (t.instanceOf(AtomType.INTEGER) && t != AtomType.UNSIGNED_LONG) {
                list = new LongList(sz);
                for (Value member : this.members()) {
                    ((LongList)list).add(((Int)member).itr());
                }
                return ((LongList)list).finish();
            }
            if (t == AtomType.FLOAT) {
                list = new FloatList(sz);
                for (Value member : this.members()) {
                    ((FloatList)list).add(((Flt)member).flt());
                }
                return ((FloatList)list).finish();
            }
            if (t == AtomType.DOUBLE) {
                list = new DoubleList(sz);
                for (Value member : this.members()) {
                    ((DoubleList)list).add(((Dbl)member).dbl());
                }
                return ((DoubleList)list).finish();
            }
            if (t.instanceOf(AtomType.STRING)) {
                list = new StringList(sz);
                for (Value member : this.members()) {
                    ((ObjectList)list).add((String)member.toJava());
                }
                return ((ObjectList)list).finish();
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(sz);
        for (Value member : this.members()) {
            list.add(member.toJava());
        }
        return list.toArray();
    }

    @Override
    public final String description() {
        return "array";
    }

    @Override
    public final void toXml(QueryPlan plan) {
        ExprList list = new ExprList();
        long size = this.arraySize();
        int max = (int)Math.min(size, 5L);
        for (int i = 0; i < max; ++i) {
            list.add(this.get(i));
        }
        plan.add(plan.create(this, "entries", size), (ExprInfo[])list.finish());
    }

    @Override
    public void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder();
        for (Value member : this.members()) {
            tb.add(tb.isEmpty() ? " " : ", ");
            long vs = member.size();
            if (vs != 1L) {
                tb.add(40);
            }
            int i = 0;
            while ((long)i < vs) {
                if (i != 0) {
                    tb.add(", ");
                }
                tb.add(member.itemAt(i));
                ++i;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        qs.bracket(tb.add(32).finish());
    }
}

