/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.parse;

import java.util.ArrayList;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.util.hash.QNmSet;
import org.basex.query.util.parse.LocalVars;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;

public final class Params {
    public final ArrayList<Param> params = new ArrayList();
    public SeqType type;

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Params add(QNm name, SeqType st, Expr expr, InputInfo info) {
        Param param = new Param();
        param.name = name;
        param.type = st;
        param.expr = expr;
        param.info = info;
        this.params.add(param);
        return this;
    }

    public Params finish(QueryContext qc, StaticContext sc, LocalVars vars) throws QueryException {
        if (this.params.size() > 1) {
            QNmSet names = new QNmSet();
            for (Param param : this.params) {
                if (names.add(param.name)) continue;
                throw QueryError.FUNCDUPL_X.get(param.info, param.name);
            }
        }
        for (Param param : this.params) {
            param.var = new Var(param.name, param.type, qc, sc, param.info, true);
            vars.add(param.var);
        }
        return this;
    }

    public Var[] vars() {
        int ps = this.params.size();
        Var[] vars = new Var[ps];
        for (int p = 0; p < ps; ++p) {
            vars[p] = this.params.get((int)p).var;
        }
        return vars;
    }

    public Expr[] defaults() {
        int ps = this.params.size();
        Expr[] defaults = new Expr[ps];
        for (int p = 0; p < ps; ++p) {
            defaults[p] = this.params.get((int)p).expr;
        }
        return defaults;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('(');
        for (Param param : this.params) {
            sb.append(sb.length() != 1 ? ", " : "").append(param);
        }
        return sb.append(')').toString();
    }

    private static final class Param {
        private InputInfo info;
        private QNm name;
        private SeqType type;
        private Expr expr;
        private Var var;

        private Param() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append('$').append(this.name);
            if (this.type != null) {
                sb.append(" as ").append(this.type);
            }
            if (this.expr != null) {
                sb.append(" := ").append(this.expr);
            }
            return sb.toString();
        }
    }
}

