/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.value.item.QNm;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.hash.ASet;

public class QNmSet
extends ASet
implements Iterable<QNm> {
    protected QNm[] keys = new QNm[this.capacity()];
    private int[] hash = new int[this.capacity()];

    public QNmSet() {
        super(8L);
    }

    public final boolean add(QNm key) {
        return this.index(key) > 0;
    }

    public final int put(QNm key) {
        int id = this.index(key);
        return Math.abs(id);
    }

    public final boolean contains(QNm key) {
        return this.id(key) > 0;
    }

    public final int id(QNm key) {
        int b = key.hash(null) & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (key.eq(this.keys[id])) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    public final QNm key(int id) {
        return this.keys[id];
    }

    private int index(QNm key) {
        int h = key.hash(null);
        int b = h & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.keys[id].eq(key)) {
                return -id;
            }
            id = this.next[id];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.hash[s] = h;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected final int hash(int id) {
        return this.hash[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new QNm[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }

    @Override
    public final Iterator<QNm> iterator() {
        return new ArrayIterator<QNm>(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(this.keys);
    }
}

