/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.hash;

import java.util.Arrays;
import java.util.Iterator;
import org.basex.query.QueryException;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.hash.ItemSet;
import org.basex.query.value.item.Item;
import org.basex.util.Array;
import org.basex.util.ArrayIterator;
import org.basex.util.InputInfo;
import org.basex.util.hash.ASet;

public class HashItemSet
extends ASet
implements ItemSet {
    private final boolean eq;
    private final InputInfo info;
    private final DeepEqual deep;
    private Item[] keys;
    private int[] hash;

    public HashItemSet(boolean eq, InputInfo info) {
        super(8L);
        this.eq = eq;
        this.info = info;
        this.deep = new DeepEqual(info);
        this.keys = new Item[this.capacity()];
        this.hash = new int[this.capacity()];
    }

    @Override
    public boolean add(Item key) throws QueryException {
        return this.index(key) >= 0;
    }

    public boolean contains(Item key) throws QueryException {
        return this.id(key) > 0;
    }

    public int id(Item key) throws QueryException {
        int b = key.hash(this.info) & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.eq ? this.keys[id].eq(key, null, null, this.info) : this.deep.equal(this.keys[id], key)) {
                return id;
            }
            id = this.next[id];
        }
        return 0;
    }

    private int index(Item key) throws QueryException {
        int h = key.hash(this.info);
        int b = h & this.capacity() - 1;
        int id = this.buckets[b];
        while (id != 0) {
            if (this.eq ? this.keys[id].eq(key, null, null, this.info) : this.deep.equal(this.keys[id], key)) {
                return -id;
            }
            id = this.next[id];
        }
        int s = this.size++;
        if (this.checkCapacity()) {
            b = h & this.capacity() - 1;
        }
        this.next[s] = this.buckets[b];
        this.keys[s] = key;
        this.hash[s] = h;
        this.buckets[b] = s;
        return s;
    }

    @Override
    protected int hash(int id) {
        return this.hash[id];
    }

    @Override
    protected void rehash(int newSize) {
        this.keys = Array.copy(this.keys, new Item[newSize]);
        this.hash = Arrays.copyOf(this.hash, newSize);
    }

    @Override
    public Iterator<Item> iterator() {
        return new ArrayIterator<Item>(this.keys, 1, this.size);
    }

    public String toString() {
        return this.toString(this.keys);
    }
}

