/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.fingertree;

import org.basex.query.QueryContext;
import org.basex.query.util.fingertree.DeepTree;
import org.basex.query.util.fingertree.EmptyTree;
import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.Node;
import org.basex.query.util.fingertree.NodeLike;
import org.basex.query.util.fingertree.TreeSlice;

final class SingletonTree<N, E>
extends FingerTree<N, E> {
    final Node<N, E> elem;

    SingletonTree(Node<N, E> elem) {
        this.elem = elem;
    }

    @Override
    public DeepTree<N, E> cons(Node<N, E> fst) {
        long leftSize = fst.size();
        Node[] left = new Node[]{fst};
        Node[] right = new Node[]{this.elem};
        return DeepTree.get(left, leftSize, right, leftSize + this.elem.size());
    }

    @Override
    public DeepTree<N, E> snoc(Node<N, E> lst) {
        long leftSize = this.elem.size();
        Node[] left = new Node[]{this.elem};
        Node[] right = new Node[]{lst};
        return DeepTree.get(left, leftSize, right, leftSize + lst.size());
    }

    @Override
    public Node<N, E> head() {
        return this.elem;
    }

    @Override
    public Node<N, E> last() {
        return this.elem;
    }

    @Override
    public FingerTree<N, E> init() {
        return EmptyTree.getInstance();
    }

    @Override
    public FingerTree<N, E> tail() {
        return EmptyTree.getInstance();
    }

    @Override
    public long size() {
        return this.elem.size();
    }

    @Override
    public FingerTree<N, E> concat(Node<N, E>[] mid, long size, FingerTree<N, E> other) {
        return other.isEmpty() ? this.addAll(mid, size, false) : other.addAll(mid, size, true).cons(this.elem);
    }

    @Override
    public FingerTree<N, E> reverse(QueryContext qc) {
        return new SingletonTree<N, E>(this.elem.reverse());
    }

    @Override
    public FingerTree<N, E> set(long pos, E val) {
        return new SingletonTree<N, E>(this.elem.set(pos, val));
    }

    @Override
    public FingerTree<N, E> insert(long pos, E val, QueryContext qc) {
        Node[] siblings = new Node[4];
        if (!this.elem.insert(siblings, pos, val)) {
            return new SingletonTree<N, E>(siblings[1]);
        }
        Node l = siblings[1];
        Node r = siblings[2];
        Node[] left = new Node[]{l};
        Node[] right = new Node[]{r};
        return DeepTree.get(left, l.size(), right, this.elem.size() + 1L);
    }

    @Override
    public TreeSlice<N, E> remove(long pos, QueryContext qc) {
        NodeLike<N, E>[] removed = this.elem.remove(null, null, pos);
        return new TreeSlice<N, E>(removed[1]);
    }

    @Override
    public TreeSlice<N, E> slice(long pos, long len) {
        if (pos == 0L && len == this.elem.size()) {
            return new TreeSlice(this);
        }
        return new TreeSlice<N, E>(this.elem.slice(pos, len));
    }

    @Override
    FingerTree<N, E> addAll(Node<N, E>[] nodes, long size, boolean left) {
        if (nodes.length == 0) {
            return this;
        }
        if (nodes.length <= 5) {
            Node[] arr = new Node[]{this.elem};
            return left ? DeepTree.get(nodes, arr) : DeepTree.get(arr, nodes);
        }
        FingerTree<N, E> tree = SingletonTree.buildTree(nodes, nodes.length, size);
        return left ? tree.snoc(this.elem) : tree.cons(this.elem);
    }

    @Override
    public FingerTree<N, E> replaceHead(Node<N, E> head) {
        return new SingletonTree<N, E>(head);
    }

    @Override
    public FingerTree<N, E> replaceLast(Node<N, E> head) {
        return new SingletonTree<N, E>(head);
    }

    @Override
    void toString(StringBuilder sb, int indent) {
        sb.append("  ".repeat(indent)).append("Single[\n");
        SingletonTree.toString(this.elem, sb, indent + 1);
        sb.append('\n').append("  ".repeat(indent)).append(']');
    }

    @Override
    public long checkInvariants() {
        return this.elem.checkInvariants();
    }
}

