/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.collation;

import java.text.Collator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.query.util.collation.BaseXCollation;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.collation.CollationOptions;
import org.basex.util.Strings;
import org.basex.util.options.EnumOption;
import org.basex.util.options.StringOption;

public final class BaseXCollationOptions
extends CollationOptions {
    public static final StringOption LANG = new StringOption("lang");
    public static final EnumOption<Strength> STRENGTH = new EnumOption<Strength>("strength", Strength.class);
    public static final EnumOption<Decomposition> DECOMPOSITION = new EnumOption<Decomposition>("decomposition", Decomposition.class);
    private final boolean fallback;

    public BaseXCollationOptions(boolean fallback) {
        this.fallback = fallback;
    }

    @Override
    public Collation get(HashMap<String, String> args) throws BaseXException {
        return new BaseXCollation(this.collator(args));
    }

    private Collator collator(HashMap<String, String> args) throws BaseXException {
        if (this.fallback) {
            for (Map.Entry<String, String> entry : args.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                if (!name.equals(STRENGTH.name())) continue;
                if (Strings.eq(value, "1")) {
                    value = Strength.PRIMARY.toString();
                } else if (Strings.eq(value, "2")) {
                    value = Strength.SECONDARY.toString();
                } else if (Strings.eq(value, "3")) {
                    value = Strength.TERTIARY.toString();
                } else if (Strings.eq(value, "quaternary", "4", "5")) {
                    value = Strength.IDENTICAL.toString();
                }
                this.assign(name, value);
            }
        } else {
            this.assign(args);
        }
        Locale locale = Locale.US;
        if (this.contains(LANG) && (locale = CollationOptions.Locales.MAP.get(this.get(LANG))) == null) {
            throw this.error(LANG);
        }
        Collator coll = Collator.getInstance(locale);
        if (this.contains(STRENGTH)) {
            coll.setStrength(this.get(BaseXCollationOptions.STRENGTH).value);
        }
        if (this.contains(DECOMPOSITION)) {
            coll.setDecomposition(this.get(BaseXCollationOptions.DECOMPOSITION).value);
        }
        return coll;
    }

    public static enum Decomposition {
        NONE(0),
        FULL(2),
        STANDARD(1);

        public final int value;

        private Decomposition(int d) {
            this.value = d;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum Strength {
        PRIMARY(0),
        SECONDARY(1),
        TERTIARY(2),
        IDENTICAL(3);

        public final int value;

        private Strength(int v) {
            this.value = v;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

