/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.value.item.QNm;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.hash.WeakTokenSet;

public final class SharedData {
    private static final Pattern EQNAME = Pattern.compile("Q\\{([^{}]*)\\}(.*)$");
    private final TokenObjMap<QNm> qnames = new TokenObjMap();
    private final WeakTokenSet tokens = new WeakTokenSet();

    public QNm qname(byte[] name) {
        return this.qname(name, null);
    }

    public QNm qname(byte[] name, byte[] uri) {
        return this.qnames.computeIfAbsent(uri != null ? Token.concat(name, Token.SPACE, uri) : name, () -> new QNm(name, uri));
    }

    public QNm eqname(byte[] eqname) {
        Matcher m = EQNAME.matcher(Token.string(eqname));
        if (m.matches()) {
            byte[] ncname = Token.token(m.group(2));
            byte[] uri = Token.token(m.group(1));
            if (XMLToken.isNCName(ncname)) {
                return this.qname(ncname, uri);
            }
        }
        return null;
    }

    public byte[] token(byte[] token) {
        return token.length == 0 ? Token.EMPTY : this.tokens.put(token);
    }
}

