/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;

public final class DBOptions {
    private final HashMap<Option<?>, Object> map = new HashMap();

    public DBOptions(HashMap<String, String> options, List<Option<?>> supported, InputInfo info) throws QueryException {
        this(options, (Option[])supported.toArray(Option[]::new), info);
    }

    public DBOptions(HashMap<String, String> qopts, Option<?>[] supported, InputInfo info) throws QueryException {
        HashMap support = new HashMap();
        for (Option<?> option : supported) {
            support.put(option.name().toLowerCase(Locale.ENGLISH), option);
        }
        for (Map.Entry entry : qopts.entrySet()) {
            String key = (String)entry.getKey();
            Option option = (Option)support.get(key);
            if (option == null) {
                throw QueryError.BASEX_OPTIONS1_X.get(info, key);
            }
            String value = (String)entry.getValue();
            if (option instanceof NumberOption) {
                int v = Strings.toInt(value);
                if (v < 0) {
                    throw QueryError.BASEX_OPTIONS_X_X.get(info, key, value);
                }
                this.map.put(option, v);
                continue;
            }
            if (option instanceof BooleanOption) {
                boolean yes = Strings.toBoolean(value);
                if (!yes && !Strings.no(value)) {
                    throw QueryError.BASEX_OPTIONS_X_X.get(info, key, value);
                }
                this.map.put(option, yes);
                continue;
            }
            if (option instanceof StringOption) {
                this.map.put(option, value);
                continue;
            }
            if (option instanceof EnumOption) {
                EnumOption eo = (EnumOption)option;
                Object ev = eo.get(value);
                if (ev == null) {
                    throw QueryError.BASEX_OPTIONS_X_X.get(info, key, value);
                }
                this.map.put(option, ev);
                continue;
            }
            if (option instanceof OptionsOption) {
                try {
                    Object o = ((OptionsOption)option).newInstance();
                    ((Options)o).assign(value);
                    this.map.put(option, o);
                    continue;
                }
                catch (BaseXException ex) {
                    throw QueryError.BASEX_OPTIONS2_X.get(info, ex);
                }
            }
            throw Util.notExpected();
        }
    }

    public Object get(Option<?> option) {
        return this.map.get(option);
    }

    public void assignIfAbsent(Option<?> option, Object value) {
        this.map.putIfAbsent(option, value);
    }

    public MainOptions assignTo(MainOptions opts) {
        this.map.forEach(opts::put);
        return opts;
    }
}

