/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Copy;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Transform
extends Copy {
    private final Let[] copies;

    public Transform(InputInfo info, Let[] copies, Expr modify, Expr rtrn) {
        super(info, SeqType.ITEM_ZM, modify, rtrn);
        this.copies = copies;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        for (Let copy : this.copies) {
            copy.exprType.assign(copy.expr);
        }
        return super.compile(cc);
    }

    @Override
    public void checkUp() throws QueryException {
        for (Let copy : this.copies) {
            copy.checkUp();
        }
        super.checkUp();
        this.result().checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Updates updates;
        Updates tmp = qc.updates();
        qc.updates = updates = new Updates(true);
        try {
            for (Let copy : this.copies) {
                Iter iter = copy.expr.iter(qc);
                Item item = iter.next();
                Value error = null;
                if (item == null) {
                    error = Empty.VALUE;
                } else if (!(item instanceof ANode)) {
                    error = item;
                } else {
                    Item item2 = iter.next();
                    if (item2 != null) {
                        error = ValueBuilder.concat(item, item2, qc);
                    }
                }
                if (error != null) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info(), copy.var.name, error);
                }
                item = ((ANode)item).copy(qc);
                qc.set(copy.var, item);
                updates.addData(item.data());
            }
            if (!this.modify().value(qc).isEmpty()) {
                throw QueryError.UPMODIFY.get(this.info, new Object[0]);
            }
            updates.prepare(qc);
            updates.apply(qc);
        }
        finally {
            qc.updates = tmp;
        }
        return this.result().value(qc);
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Let copy : this.copies) {
            if (!copy.has(flags)) continue;
            return true;
        }
        return Flag.CNS.in(flags) || Flag.UPD.in(flags) && this.result().has(Flag.UPD) || super.has(Flag.UPD.remove(flags));
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Let copy : this.copies) {
            if (copy.inlineable(ic)) continue;
            return false;
        }
        return super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.copies).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean a = ic.inline(this.copies);
        boolean b = ic.inline(this.exprs);
        return a || b ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Transform(this.info, (Let[])Transform.copyAll((CompileContext)cc, vm, (Expr[])this.copies), this.modify().copy(cc, vm), this.result().copy(cc, vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Transform.visitAll(visitor, this.copies) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Let copy : this.copies) {
            size += copy.exprSize();
        }
        return size + super.exprSize();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Transform && Array.equals(this.copies, ((Transform)obj).copies) && super.equals(obj);
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.copies, this.exprs});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("copy");
        boolean more = false;
        for (Let copy : this.copies) {
            if (more) {
                qs.token(", ");
            } else {
                more = true;
            }
            qs.token(copy.var.id()).token(":=").token(copy.expr);
        }
        qs.token("modify").token(this.modify()).token("return").token(this.result());
    }
}

