/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import java.util.concurrent.RecursiveTask;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.xquery.TaskContext;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.seq.Empty;

final class XQueryTask
extends RecursiveTask<Value> {
    private final TaskContext tc;
    private final int start;
    private final int end;

    XQueryTask(TaskContext tc) {
        this(tc, 0, tc.funcs.size());
    }

    private XQueryTask(TaskContext tc, int start, int end) {
        this.tc = tc;
        this.start = start;
        this.end = end;
    }

    @Override
    protected Value compute() {
        block10: {
            int size = this.end - this.start;
            if (size == 1) {
                QueryContext qc = new QueryContext(this.tc.qc);
                try {
                    Value value = this.tc.funcs.get(this.start).invoke(qc, this.tc.info, new Value[0]);
                    qc.close();
                    return value;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            qc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (QueryException ex) {
                        if (this.tc.errors) {
                            this.completeExceptionally(ex);
                            this.cancel(true);
                        }
                        break block10;
                    }
                }
            }
            int middle = this.start + size / 2;
            XQueryTask task2 = new XQueryTask(this.tc, middle, this.end);
            task2.fork();
            XQueryTask task1 = new XQueryTask(this.tc, this.start, middle);
            Value value1 = (Value)task1.invoke();
            Value value2 = (Value)task2.join();
            if (this.tc.results) {
                return ValueBuilder.concat(value1, value2, this.tc.qc);
            }
        }
        return Empty.VALUE;
    }
}

