/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.web;

import java.util.HashMap;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.http.HTTPText;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

abstract class WebFn
extends StandardFunc {
    WebFn() {
    }

    final String createUrl(QueryContext qc) throws QueryException {
        byte[] url = this.toToken(this.arg(0), qc);
        Item params = this.arg(1).item(qc, this.info);
        byte[] anchor = this.toZeroToken(this.arg(2), qc);
        XQMap map = params.isEmpty() ? XQMap.empty() : this.toMap(params);
        TokenBuilder tb = new TokenBuilder().add(url);
        int c = 0;
        for (Item key : map.keys()) {
            byte[] name = key.string(this.info);
            for (Item item : map.get(key, this.info)) {
                tb.add(c++ == 0 ? 63 : 38).add(Token.encodeUri(name, false));
                tb.add(61).add(Token.encodeUri(item.string(this.info), false));
            }
        }
        if (anchor.length > 0) {
            tb.add(35).add(Token.encodeUri(anchor, false));
        }
        return tb.toString();
    }

    final FNode createResponse(ResponseOptions response, HashMap<String, String> headers, HashMap<String, String> output) throws QueryException {
        FBuilder rrest = FElem.build(HTTPText.Q_REST_RESPONSE).declareNS();
        FBuilder hresp = FElem.build(HTTPText.Q_HTTP_RESPONSE).declareNS();
        for (Option<?> o : response) {
            if (!response.contains(o)) continue;
            hresp.add(new QNm(o.name()), response.get(o));
        }
        headers.forEach((name, value) -> {
            if (!value.isEmpty()) {
                hresp.add(FElem.build(HTTPText.Q_HTTP_HEADER).add(HTTPText.Q_NAME, name).add(HTTPText.Q_VALUE, value));
            }
        });
        rrest.add(hresp);
        if (output != null) {
            SerializerOptions sopts = SerializerMode.DEFAULT.get();
            for (String entry : output.keySet()) {
                if (sopts.option(entry) != null) continue;
                throw QueryError.INVALIDOPTION_X.get(this.info, entry);
            }
            FBuilder param = FElem.build(FuncOptions.Q_SERIALIZTION_PARAMETERS).declareNS();
            output.forEach((name, value) -> {
                if (!value.isEmpty()) {
                    QNm qnm = new QNm(QueryText.OUTPUT_PREFIX, (String)name, QueryText.OUTPUT_URI);
                    param.add(FElem.build(qnm).add(HTTPText.Q_VALUE, value));
                }
            });
            rrest.add(param);
        }
        return rrest.finish();
    }

    public static class ResponseOptions
    extends Options {
        public static final NumberOption STATUS = new NumberOption("status");
        public static final StringOption MESSAGE = new StringOption("message");
    }
}

