/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.validate;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOStream;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.validate.ErrorInfo;
import org.basex.query.func.validate.ValidateFn;
import org.basex.query.func.validate.Validation;
import org.basex.query.func.validate.ValidationHandler;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.util.Reflect;
import org.basex.util.Resolver;
import org.basex.util.Strings;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class ValidateXsd
extends ValidateFn {
    private static final ConcurrentHashMap<String, Schema> MAP = new ConcurrentHashMap();
    private static final String FACTORY = "http://www.w3.org/2001/XMLSchema";
    private static final String SAXON_VERSION_URI = "http://saxon.sf.net/feature/xsd-version";
    static final String[] IMPL = new String[]{"com.saxonica.ee.jaxp.SchemaFactoryImpl", "Saxon EE", "1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory", "Xerces", "1.1", "org.apache.xerces.jaxp.validation.XMLSchemaFactory", "Xerces", "1.0", "", "Java", "1.0"};
    static final int OFFSET;
    private static final boolean SAXON;
    private static final boolean JAVA;

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.check(qc);
    }

    @Override
    public ArrayList<ErrorInfo> errors(final QueryContext qc) throws QueryException {
        return this.process(new Validation(){

            @Override
            void process(ValidationHandler handler) throws IOException, SAXException, QueryException {
                Schema s;
                IO input = ValidateXsd.this.read(ValidateXsd.this.toNodeOrAtomItem(ValidateXsd.this.arg(0), qc), null);
                Empty schema = ValidateXsd.this.defined(1) ? ValidateXsd.this.toNodeOrAtomItem(ValidateXsd.this.arg(1), qc) : Empty.VALUE;
                HashMap options = ValidateXsd.this.toOptions(ValidateXsd.this.arg(2), qc);
                String url = schema.isEmpty() ? "" : this.prepare(ValidateXsd.this.read(schema, null), handler).url();
                String caching = (String)options.remove("cache");
                boolean cache = caching != null && Strings.toBoolean(caching);
                Schema schema2 = s = cache ? MAP.get(url) : null;
                if (s == null) {
                    LSResourceResolver ls;
                    SchemaFactory sf;
                    SchemaFactory schemaFactory = sf = JAVA ? SchemaFactory.newInstance(ValidateXsd.FACTORY) : (SchemaFactory)Reflect.get(Reflect.find(IMPL[OFFSET]));
                    if (SAXON) {
                        sf.setProperty(ValidateXsd.SAXON_VERSION_URI, IMPL[OFFSET + 2]);
                    }
                    if ((ls = Resolver.resources(qc.context.options)) != null) {
                        sf.setResourceResolver(ls);
                    }
                    for (Map.Entry entry : options.entrySet()) {
                        sf.setFeature((String)entry.getKey(), Strings.toBoolean((String)entry.getValue()));
                    }
                    Schema schema3 = s = url.isEmpty() ? sf.newSchema() : sf.newSchema(new URL(url));
                    if (cache) {
                        MAP.put(url, s);
                    }
                }
                Validator v = s.newValidator();
                v.setErrorHandler(handler);
                v.validate(input instanceof IOContent || input instanceof IOStream ? new StreamSource(input.inputStream()) : new StreamSource(input.url()));
            }
        });
    }

    static {
        int i = 0;
        int il = IMPL.length;
        while (i + 3 < il && Reflect.find(IMPL[i]) == null) {
            i += 3;
        }
        OFFSET = i;
        SAXON = i == 0;
        JAVA = i == 9;
    }
}

