/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Int;
import org.basex.util.InputInfo;

public final class UtilCountWithin
extends StandardFunc {
    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        long[] minMax = this.minMax(qc);
        long min = minMax[0];
        long max = minMax[1];
        Iter input = this.arg(0).iter(qc);
        long size = input.size();
        if (size == -1L) {
            if (max == Long.MAX_VALUE) {
                while (++size < min && qc.next(input) != null) {
                }
            } else {
                while (++size <= max && qc.next(input) != null) {
                }
            }
        }
        return Bln.get(size >= min && size <= max);
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.COUNT, cc));
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        long[] minMax = this.minMaxValues(cc.qc);
        if (minMax != null) {
            long min = minMax[0];
            long max = minMax[1];
            if (min > max) {
                return Bln.FALSE;
            }
            if (min <= 0L && max == Long.MAX_VALUE) {
                return Bln.TRUE;
            }
            long size = input.size();
            if (size >= 0L && !input.has(Flag.NDT)) {
                return Bln.get(size >= min && size <= max);
            }
            if (max == 0L) {
                return cc.function(Function.EMPTY, this.info, input);
            }
            if (min == 1L && max == Long.MAX_VALUE) {
                return cc.function(Function.EXISTS, this.info, input);
            }
            if (input.seqType().zeroOrOne()) {
                if (min < 1L && max <= 1L) {
                    return Bln.TRUE;
                }
                if (min >= 2L) {
                    return Bln.FALSE;
                }
            }
        }
        return this.embed(cc, true);
    }

    @Override
    public Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        long[] mm = this.minMaxValues(cc.qc);
        long[] cmm = null;
        if (mm != null) {
            if (Function._UTIL_COUNT_WITHIN.is(expr)) {
                cmm = ((UtilCountWithin)expr).minMaxValues(cc.qc);
            } else if (Function.EXISTS.is(expr)) {
                cmm = new long[]{1L, Long.MAX_VALUE};
            } else if (Function.EMPTY.is(expr)) {
                cmm = new long[]{0L, 0L};
            }
        }
        if (cmm != null && this.arg(0).equals(expr.arg(0)) && (!or || mm[1] >= cmm[0] && mm[0] <= cmm[1])) {
            long mn = or ? Math.min(mm[0], cmm[0]) : Math.max(mm[0], cmm[0]);
            long mx = or ? Math.max(mm[1], cmm[1]) : Math.min(mm[1], cmm[1]);
            ExprList args = (ExprList)((Object)((ExprList)((Object)new ExprList(3L).add(this.arg(0)))).add(Int.get(mn)));
            if (mx < Long.MAX_VALUE) {
                args.add(Int.get(mx));
            }
            return cc.function(Function._UTIL_COUNT_WITHIN, this.info, (Expr[])args.finish());
        }
        return null;
    }

    private long[] minMaxValues(QueryContext qc) throws QueryException {
        return this.arg(1) instanceof Value && (!this.defined(2) || this.arg(2) instanceof Value) ? this.minMax(qc) : null;
    }

    private long[] minMax(QueryContext qc) throws QueryException {
        Expr arg1 = this.arg(1);
        Expr arg2 = this.arg(2);
        long min = this.toLong(arg1, qc);
        long max = this.defined(2) ? (arg1 == arg2 ? min : this.toLong(arg2, qc)) : Long.MAX_VALUE;
        return new long[]{min, max};
    }
}

