/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.sql.SqlExecute;
import org.basex.query.func.sql.SqlType;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.util.Token;
import org.basex.util.Util;

public final class SqlExecutePrepared
extends SqlExecute {
    private static final byte[] TYPE = Token.token("type");
    private static final byte[] NULL = Token.token("null");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        ANode prms;
        PreparedStatement ps = this.prepared(qc);
        Item params = this.arg(1).item(qc, this.info);
        SqlExecute.StatementOptions options = this.toOptions(this.arg(2), new SqlExecute.StatementOptions(), true, qc);
        ANode aNode = prms = params.isEmpty() ? null : this.toElem(params, qc);
        if (prms != null && !prms.qname().eq(Q_PARAMETERS)) {
            throw QueryError.INVALIDOPTION_X.get(this.info, new Object[]{prms.qname().local()});
        }
        try {
            ps.setQueryTimeout(options.get(SqlExecute.StatementOptions.TIMEOUT));
            if (prms != null) {
                this.setParameters(prms.childIter(), ps);
            }
            return this.iter(ps, false, ps.execute());
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw QueryError.SQL_ERROR_X.get(this.info, ex);
        }
    }

    private void setParameters(BasicNodeIter params, PreparedStatement ps) throws QueryException {
        ANode next;
        int i = 1;
        while ((next = params.next()) != null) {
            ANode attr;
            if (!next.qname().eq(Q_PARAMETER)) {
                throw QueryError.INVALIDOPTION_X.get(this.info, new Object[]{next.qname().local()});
            }
            BasicNodeIter attrs = next.attributeIter();
            String type = null;
            boolean isNull = false;
            while ((attr = attrs.next()) != null) {
                if (Token.eq(attr.name(), TYPE)) {
                    type = Token.string(attr.string());
                    continue;
                }
                if (Token.eq(attr.name(), NULL)) {
                    isNull = attr.string() != null && Bln.parse(attr, this.info);
                    continue;
                }
                throw QueryError.SQL_ATTRIBUTE_X.get(this.info, new Object[]{attr.name()});
            }
            if (type == null) {
                throw QueryError.SQL_PARAMETERS.get(this.info, new Object[0]);
            }
            String value = Token.string(next.string());
            try {
                SqlType st = SqlType.valueOf(type.toUpperCase(Locale.ENGLISH));
                if (isNull) {
                    st.setNull(i, ps);
                } else {
                    st.set(i, value, ps);
                }
            }
            catch (SQLException ex) {
                throw QueryError.SQL_ERROR_X.get(this.info, ex);
            }
            catch (IllegalArgumentException ex) {
                Util.debug(ex);
                throw QueryError.SQL_TYPE_X_X.get(this.info, type, value);
            }
            ++i;
        }
    }
}

