/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Method;
import org.basex.core.MainOptions;
import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.JavaCall;
import org.basex.query.func.java.JavaCandidate;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.XQJava;
import org.basex.query.value.seq.Empty;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class StaticJavaCall
extends JavaCall {
    private final Object module;
    private final Method method;
    private final Class<?>[] params;

    StaticJavaCall(Object module, Method method, Expr[] args, Perm perm, boolean updating, StaticContext sc, InputInfo info) {
        super(args, perm, updating, sc, info);
        this.module = module;
        this.method = method;
        this.params = method.getParameterTypes();
        int pl = this.params.length;
        this.xquery = new boolean[pl];
        for (int p = 0; p < pl; ++p) {
            this.xquery[p] = Value.class.isAssignableFrom(this.params[p]);
        }
    }

    @Override
    public boolean vacuous() {
        return this.method.getReturnType() == Void.TYPE;
    }

    @Override
    protected Value eval(QueryContext qc, MainOptions.WrapOptions wrap) throws QueryException {
        JavaCandidate jc = this.candidate(this.values(qc), this.params, true);
        if (jc == null) {
            throw QueryError.JAVAARGS_X_X_X.get(this.info, this.name(), JavaCall.paramTypes(this.method, true), StaticJavaCall.argTypes(this.exprs));
        }
        if (this.module instanceof QueryModule) {
            QueryModule qm = (QueryModule)this.module;
            qm.staticContext = this.sc;
            qm.queryContext = qc;
        }
        try {
            Object result = this.method.invoke(this.module, jc.arguments);
            if (wrap == MainOptions.WrapOptions.INSTANCE) {
                return new XQJava(this.module);
            }
            if (wrap == MainOptions.WrapOptions.VOID) {
                return Empty.VALUE;
            }
            return StaticJavaCall.toValue(result, qc, this.info, wrap);
        }
        catch (Throwable th) {
            throw this.executionError(th, jc.arguments);
        }
    }

    @Override
    public StaticJavaCall copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new StaticJavaCall(this.module, this.method, StaticJavaCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.perm, this.updating, this.sc, this.info));
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.UPD.in(flags) && this.method.getAnnotation(QueryModule.Updating.class) != null || Flag.NDT.in(flags) && this.method.getAnnotation(QueryModule.Deterministic.class) == null || (Flag.CTX.in(flags) || Flag.POS.in(flags)) && this.method.getAnnotation(QueryModule.FocusDependent.class) != null || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return (ic.var != null || this.method.getAnnotation(QueryModule.FocusDependent.class) == null) && super.inlineable(ic);
    }

    @Override
    String desc() {
        return this.name();
    }

    @Override
    String name() {
        return StaticJavaCall.className(this.module.getClass()) + ":" + this.method.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticJavaCall)) {
            return false;
        }
        StaticJavaCall j = (StaticJavaCall)obj;
        return this.module.equals(j.module) && this.method.equals(j.method) && Array.equals(this.params, j.params) && super.equals(obj);
    }
}

