/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.index;

import org.basex.data.Data;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.index.IndexFn;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class IndexFacets
extends IndexFn {
    @Override
    public FNode item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.toData(qc);
        boolean flat = this.defined(1) && Token.eq(this.toToken(this.arg(1), qc), FLAT);
        return FDoc.build().add(flat ? IndexFacets.flat(data) : IndexFacets.tree(data, data.paths.root().get(0))).finish();
    }

    private static FBuilder flat(Data data) {
        FBuilder elem = FElem.build(NodeType.DOCUMENT_NODE.qname());
        IndexFacets.index(data.elemNames, Q_ELEMENT, elem);
        IndexFacets.index(data.attrNames, Q_ATTRIBUTE, elem);
        return elem;
    }

    private static FBuilder tree(Data data, PathNode root) {
        Names names;
        FBuilder elem = FElem.build(ANode.type(root.kind).qname());
        boolean elm = root.kind == 1;
        Names names2 = names = elm ? data.elemNames : data.attrNames;
        if (root.kind == 3 || elm) {
            elem.add(Q_NAME, names.key(root.name));
        }
        IndexFacets.stats(root.stats, elem);
        for (PathNode pn : root.children) {
            elem.add(IndexFacets.tree(data, pn));
        }
        return elem;
    }

    private static void index(Names names, QNm name, FBuilder root) {
        int ns = names.size();
        for (int n = 1; n <= ns; ++n) {
            FBuilder sub = FElem.build(name).add(Q_NAME, names.key(n));
            IndexFacets.stats(names.stats(n), sub);
            root.add(sub);
        }
    }

    private static void stats(Stats stats, FBuilder elem) {
        byte type = stats.type;
        if (!StatsType.isNone(type)) {
            elem.add(Q_TYPE, StatsType.toString(type));
        }
        elem.add(Q_COUNT, stats.count);
        if (StatsType.isInteger(type) || StatsType.isDouble(type)) {
            int mn = (int)stats.min;
            int mx = (int)stats.max;
            elem.add(Q_MIN, (double)mn == stats.min ? (double)mn : stats.min);
            elem.add(Q_MAX, (double)mx == stats.max ? (double)mx : stats.max);
        }
        if (StatsType.isCategory(type)) {
            TokenIntMap map = stats.values;
            IntList list = new IntList(map.size());
            TokenList values = new TokenList(map.size());
            for (byte[] value : map) {
                list.add(map.get(value));
                values.add(value);
            }
            for (Object o : (Object)list.createOrder(false)) {
                byte[] value = (byte[])values.get((int)o);
                elem.add(FElem.build(Q_ENTRY).add(Q_COUNT, map.get(value)).add(value));
            }
        }
    }
}

