/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.io.InputStream;
import org.basex.io.IO;
import org.basex.io.in.DecodingException;
import org.basex.io.in.InputException;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.util.Strings;
import org.basex.util.Token;

public abstract class Parse
extends StandardFunc {
    IO input;

    protected IO input(byte[] uri) {
        return this.input != null ? this.input : (Uri.get(uri).isValid() ? this.sc.resolve(Token.string(uri)) : null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    final Item unparsedText(QueryContext qc, boolean check, boolean encoding) throws QueryException {
        try {
            IO io = this.input;
            if (io == null) {
                Item href = this.arg(0).atomItem(qc, this.info);
                if (href.isEmpty()) {
                    return check ? Bln.FALSE : Empty.VALUE;
                }
                io = this.input(this.toToken(href));
                if (io == null) {
                    throw QueryError.INVURL_X.get(this.info, href);
                }
            }
            if (Strings.contains(io.path(), '#')) {
                throw QueryError.FRAGID_X.get(this.info, io);
            }
            String enc = encoding ? this.toEncodingOrNull(this.arg(1), QueryError.ENCODING_X, qc) : null;
            String[] pathEnc = qc.resources.text(io);
            if (pathEnc != null) {
                io = IO.get(pathEnc[0]);
                enc = pathEnc[1];
            }
            try (InputStream is = io.inputStream();){
                Bln bln;
                TextInput ti;
                block27: {
                    ti = new TextInput(io);
                    ti.encoding(enc).validate(true);
                    if (check) break block27;
                    Str str = Str.get(ti.content());
                    ti.close();
                    return str;
                }
                try {
                    while (ti.read() != -1) {
                    }
                    bln = Bln.TRUE;
                }
                catch (Throwable throwable) {
                    try {
                        ti.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ti.close();
                return bln;
            }
            catch (IOException ex) {
                if (check) {
                    return Bln.FALSE;
                }
                if (ex instanceof DecodingException) {
                    throw QueryError.WHICHCHARS_X.get(this.info, ex);
                }
                if (ex instanceof InputException) {
                    throw QueryError.INVCHARS_X.get(this.info, ex);
                }
                throw QueryError.RESNF_X.get(this.info, io);
            }
        }
        catch (QueryException ex) {
            if (check && !ex.error().toString().startsWith(QueryError.ErrType.XPTY.name())) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }
}

