/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryRTException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.fn.FnReplicate;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ValueList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class FnSort
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        Value value = this.quickValue(input);
        return value != null ? value.iter() : this.iter(input, qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        Value value = this.quickValue(input);
        return value != null ? value : this.iter(input, qc).value(qc, this);
    }

    private Iter iter(final Value input, QueryContext qc) throws QueryException {
        Item item;
        Collation coll = this.toCollation(this.arg(1), qc);
        FItem key = this.defined(2) ? this.toFunction(this.arg(2), 1, qc) : null;
        long size = input.size();
        ValueList values = new ValueList(size);
        BasicIter<Item> iter = input.iter();
        while ((item = ((Iter)iter).next()) != null) {
            values.add((key == null ? item : key.invoke(qc, this.info, item)).atomValue(qc, this.info));
        }
        final Integer[] order = FnSort.sort(values, this, coll, qc);
        return new BasicIter<Item>(size){

            @Override
            public Item get(long i) {
                return input.itemAt(order[(int)i].intValue());
            }
        };
    }

    public static Integer[] sort(ValueList values, StandardFunc sf, Collation coll, QueryContext qc) throws QueryException {
        int al = values.size();
        Integer[] order = new Integer[al];
        for (int o = 0; o < al; ++o) {
            order[o] = o;
        }
        InputInfo info = sf.info();
        try {
            Arrays.sort(order, (i1, i2) -> {
                qc.checkStop();
                try {
                    return FnSort.compare((Value)values.get((int)i1), (Value)values.get((int)i2), coll, info);
                }
                catch (QueryException ex) {
                    throw new QueryRTException(ex);
                }
            });
        }
        catch (QueryRTException ex) {
            throw ex.getCause();
        }
        return order;
    }

    static int compare(Value value1, Value value2, Collation coll, InputInfo info) throws QueryException {
        long size1 = value1.size();
        long size2 = value2.size();
        long il = Math.min(size1, size2);
        int i = 0;
        while ((long)i < il) {
            Item item2;
            Item item1 = value1.itemAt(i);
            if (!item1.comparable(item2 = value2.itemAt(i))) {
                throw QueryError.diffError(item1, item2, info);
            }
            int diff = item1.diff(item2, coll, info);
            if (diff == Integer.MIN_VALUE) {
                boolean nan2;
                boolean nan1 = item1 == Dbl.NAN || item1 == Flt.NAN;
                boolean bl = nan2 = item2 == Dbl.NAN || item2 == Flt.NAN;
                int n = nan1 ? (nan2 ? 0 : -1) : (diff = 1);
            }
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        long diff = size1 - size2;
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return cc.simplify(this, mode == CompileContext.Simplify.COUNT ? this.arg(0) : this, mode);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        if (!this.defined(1)) {
            SeqType rst;
            Value value;
            if (st.zeroOrOne() && st.type.isSortable()) {
                return input;
            }
            if (input instanceof Value && (value = this.quickValue((Value)input)) != null) {
                return value;
            }
            if (Function.REPLICATE.is(input) && ((FnReplicate)input).singleEval(false) && (rst = input.arg(0).seqType()).zeroOrOne() && rst.type.isSortable()) {
                return input;
            }
            if (Function.REVERSE.is(input) || Function.SORT.is(input)) {
                Expr[] args = (Expr[])this.exprs.clone();
                args[0] = args[0].arg(0);
                return cc.function(Function.SORT, this.info, args);
            }
        } else if (this.defined(2)) {
            this.arg(2, arg -> this.coerceFunc((Expr)arg, cc, SeqType.ANY_ATOMIC_TYPE_ZM, st.with(Occ.EXACTLY_ONE)));
        }
        return this.adoptType(input);
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.HOF.in(flags) && this.defined(2) || super.has(flags);
    }

    private Value quickValue(Value input) {
        if (!this.defined(1)) {
            if (input instanceof RangeSeq) {
                RangeSeq seq = (RangeSeq)input;
                return seq.asc ? seq : seq.reverse(null);
            }
            SeqType st = input.seqType();
            if (st.type.isSortable() && (st.one() || input instanceof SingletonSeq && ((SingletonSeq)input).singleItem())) {
                return input;
            }
        }
        return null;
    }
}

