/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.list.LongList;

public final class FnRemove
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final Iter input = this.arg(0).iter(qc);
        final LongList pos = this.positions(qc);
        if (input.valueIter() || pos.size() > 1) {
            return FnRemove.value(input.value(qc, null), pos, qc).iter();
        }
        final long size = input.size();
        return new Iter(){
            final long p;
            long c;
            {
                this.p = pos.get(0);
            }

            @Override
            public Item next() throws QueryException {
                return this.c++ != this.p || input.next() != null ? input.next() : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return input.get(i + 1L < this.p ? i : i + 1L);
            }

            @Override
            public long size() {
                return Math.max(-1L, size - 1L);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value input = this.arg(0).value(qc);
        LongList pos = this.positions(qc);
        return FnRemove.value(input, pos, qc);
    }

    private static Value value(Value value, LongList list, QueryContext qc) {
        Value v = value;
        for (int l = list.size() - 1; l >= 0 && !v.isEmpty(); --l) {
            long pos = list.get(l);
            long size = v.size();
            if (pos == 0L) {
                v = v.subsequence(1L, size - 1L, qc);
                continue;
            }
            if (pos == size - 1L) {
                v = v.subsequence(0L, size - 1L, qc);
                continue;
            }
            if (pos <= 0L || pos >= size) continue;
            v = ((Seq)v).remove(pos, qc);
        }
        return v;
    }

    private LongList positions(QueryContext qc) throws QueryException {
        Item item;
        LongList pos = new LongList();
        Iter iter = this.arg(1).iter(qc);
        while ((item = qc.next(iter)) != null) {
            pos.add(this.toLong(item) - 1L);
        }
        return pos.ddo();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (this.allAreValues(false)) {
            return this.value(cc.qc);
        }
        Expr input = this.arg(0);
        Expr pos = this.arg(1);
        SeqType st = input.seqType();
        if (st.zero()) {
            return input;
        }
        long sz = -1L;
        if (pos instanceof Item && pos.size() == 1L) {
            long p = this.toLong(pos, cc.qc);
            long size = input.size();
            if (p < 1L || size > 0L && p > size) {
                return input;
            }
            if (p == 1L) {
                return cc.function(Function.TAIL, this.info, input);
            }
            if (p == size) {
                return cc.function(Function.TRUNK, this.info, input);
            }
            --sz;
        }
        this.exprType.assign(st.union(Occ.ZERO), sz).data(input);
        return this;
    }

    @Override
    public boolean ddo() {
        return this.arg(0).ddo();
    }
}

