/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.And;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpN;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Concat;
import org.basex.query.expr.Except;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Intersect;
import org.basex.query.expr.List;
import org.basex.query.expr.Or;
import org.basex.query.expr.Otherwise;
import org.basex.query.expr.Range;
import org.basex.query.expr.Union;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;

public class FnOp
extends StandardFunc {
    private static final QNm Q_X = new QNm("x");
    private static final QNm Q_Y = new QNm("y");

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Arr body;
        String operator = this.toString(this.arg(0), qc);
        int pl = 2;
        VarScope vs = new VarScope(this.sc);
        Var[] params = new Var[2];
        Expr[] args = new Expr[2];
        for (int p = 0; p < 2; ++p) {
            params[p] = vs.addNew(p == 0 ? Q_X : Q_Y, null, true, qc, ii);
            args[p] = new VarRef(ii, params[p]);
        }
        Expr arg1 = args[0];
        Expr arg2 = args[1];
        Collation coll = this.sc.collation;
        switch (operator) {
            case ",": {
                body = new List(this.info, arg1, arg2);
                break;
            }
            case "and": {
                body = new And(this.info, arg1, arg2);
                break;
            }
            case "or": {
                body = new Or(this.info, arg1, arg2);
                break;
            }
            case "+": {
                body = new Arith(this.info, arg1, arg2, Calc.PLUS);
                break;
            }
            case "-": {
                body = new Arith(this.info, arg1, arg2, Calc.MINUS);
                break;
            }
            case "*": {
                body = new Arith(this.info, arg1, arg2, Calc.MULT);
                break;
            }
            case "div": {
                body = new Arith(this.info, arg1, arg2, Calc.DIV);
                break;
            }
            case "idiv": {
                body = new Arith(this.info, arg1, arg2, Calc.IDIV);
                break;
            }
            case "mod": {
                body = new Arith(this.info, arg1, arg2, Calc.MOD);
                break;
            }
            case "=": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.EQ, coll, this.sc);
                break;
            }
            case "<": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.LT, coll, this.sc);
                break;
            }
            case "<=": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.LE, coll, this.sc);
                break;
            }
            case ">": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.GT, coll, this.sc);
                break;
            }
            case ">=": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.GE, coll, this.sc);
                break;
            }
            case "!=": {
                body = new CmpG(this.info, arg1, arg2, CmpG.OpG.NE, coll, this.sc);
                break;
            }
            case "eq": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.EQ, coll, this.sc);
                break;
            }
            case "lt": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.LT, coll, this.sc);
                break;
            }
            case "le": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.LE, coll, this.sc);
                break;
            }
            case "gt": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.GT, coll, this.sc);
                break;
            }
            case "ge": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.GE, coll, this.sc);
                break;
            }
            case "ne": {
                body = new CmpV(this.info, arg1, arg2, CmpV.OpV.NE, coll, this.sc);
                break;
            }
            case "<<": {
                body = new CmpN(this.info, arg1, arg2, CmpN.OpN.ET);
                break;
            }
            case ">>": {
                body = new CmpN(this.info, arg1, arg2, CmpN.OpN.GT);
                break;
            }
            case "is": {
                body = new CmpN(this.info, arg1, arg2, CmpN.OpN.EQ);
                break;
            }
            case "||": {
                body = new Concat(this.info, arg1, arg2);
                break;
            }
            case "|": 
            case "union": {
                body = new Union(this.info, arg1, arg2);
                break;
            }
            case "except": {
                body = new Except(this.info, arg1, arg2);
                break;
            }
            case "intersect": {
                body = new Intersect(this.info, arg1, arg2);
                break;
            }
            case "to": {
                body = new Range(this.info, arg1, arg2);
                break;
            }
            case "otherwise": {
                body = new Otherwise(this.info, arg1, arg2);
                break;
            }
            default: {
                throw QueryError.UNKNOWNOP_X.get(this.info, operator);
            }
        }
        FuncType ft = FuncType.get(((Expr)body).seqType(), SeqType.ITEM_ZM, SeqType.ITEM_ZM);
        return new FuncItem(this.sc, new AnnList(), null, params, ft, body, 2, this.info);
    }
}

