/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Cast;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.func.fn.ContextFn;
import org.basex.query.func.fn.FnString;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public final class FnNumber
extends ContextFn {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value = this.context(qc).atomItem(qc, this.info);
        if (value.isEmpty()) {
            return Dbl.NAN;
        }
        if (value.type == AtomType.DOUBLE) {
            return value;
        }
        try {
            if (this.info != null) {
                this.info.internal(true);
            }
            Item item = AtomType.DOUBLE.cast(value, qc, this.sc, this.info);
            return item;
        }
        catch (QueryException ex) {
            Util.debug(ex);
            Dbl dbl = Dbl.NAN;
            return dbl;
        }
        finally {
            if (this.info != null) {
                this.info.internal(false);
            }
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr arg;
        boolean context = this.contextAccess();
        Expr value = context ? cc.qc.focus.value : this.arg(0);
        Type type = this.argType(cc);
        if (type == AtomType.DOUBLE) {
            return context && cc.nestedFocus() ? ContextValue.get(cc, this.info) : value;
        }
        if (type != null && (arg = FnNumber.simplify(value, cc)) != null) {
            return cc.function(Function.NUMBER, this.info, arg);
        }
        return this;
    }

    private Type argType(CompileContext cc) {
        SeqType st;
        Expr value;
        Expr expr = value = this.contextAccess() ? cc.qc.focus.value : this.arg(0);
        if (value != null && (st = value.seqType()).one()) {
            return st.type.atomic();
        }
        return null;
    }

    public static Expr simplify(Expr arg, CompileContext cc) {
        Expr expr;
        Type type = arg.seqType().type;
        if (Function.STRING.is(arg)) {
            return ((FnString)arg).contextAccess() ? ContextValue.get(cc, arg.info()) : arg.arg(0);
        }
        if (arg instanceof Cast && type.isStringOrUntyped()) {
            return ((Cast)arg).expr;
        }
        if (arg instanceof TypeCheck && (type.isUntyped() || type == AtomType.ANY_ATOMIC_TYPE) && (expr = ((TypeCheck)arg).expr).seqType().one() && expr.seqType().type.isUntyped()) {
            return expr;
        }
        return null;
    }
}

