/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.ArrayList;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.expr.path.Path;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenIntMap;

public class FnMin
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.minmax(true, qc);
    }

    final Item minmax(boolean min, QueryContext qc) throws QueryException {
        Item it;
        CmpV.OpV op;
        Collation coll = this.toCollation(this.arg(1), qc);
        Expr values = this.arg(0);
        if (values instanceof Range) {
            Value value = values.value(qc);
            return value.isEmpty() ? Empty.VALUE : value.itemAt(min ? 0L : value.size() - 1L);
        }
        Iter iter = values.atomIter(qc, this.info);
        Item item = iter.next();
        if (item == null) {
            return Empty.VALUE;
        }
        Type type = item.type;
        if (!type.isSortable()) {
            throw QueryError.COMPARE_X_X.get(this.info, type, item);
        }
        CmpV.OpV opV = op = min ? CmpV.OpV.GT : CmpV.OpV.LT;
        if (item instanceof AStr) {
            Item it2;
            while ((it2 = qc.next(iter)) != null) {
                Type type2 = it2.type;
                if (!(it2 instanceof AStr)) {
                    throw QueryError.ARGTYPE_X_X_X.get(this.info, type, type2, it2);
                }
                if (op.eval(item, it2, coll, this.sc, this.info)) {
                    item = it2;
                }
                if (type == type2 || item.type != AtomType.ANY_URI) continue;
                item = AtomType.STRING.cast(item, qc, this.sc, this.info);
            }
            return item;
        }
        if (type == AtomType.BOOLEAN || item instanceof ADate || item instanceof Dur || item instanceof Bin) {
            Item it3;
            while ((it3 = qc.next(iter)) != null) {
                Type type2 = it3.type;
                if (type != type2) {
                    throw QueryError.ARGTYPE_X_X_X.get(this.info, type, type2, it3);
                }
                if (!op.eval(item, it3, coll, this.sc, this.info)) continue;
                item = it3;
            }
            return item;
        }
        if (type.isUntyped()) {
            item = AtomType.DOUBLE.cast(item, qc, this.sc, this.info);
        }
        while ((it = qc.next(iter)) != null) {
            AtomType tp = this.numType(item, it);
            if (op.eval(item, it, coll, this.sc, this.info) || Double.isNaN(it.dbl(this.info))) {
                item = it;
            }
            if (tp == null) continue;
            item = tp.cast(item, qc, this.sc, this.info);
        }
        return item;
    }

    private AtomType numType(Item item1, Item item2) throws QueryException {
        Type type2 = item2.type;
        if (type2.isUntyped()) {
            return AtomType.DOUBLE;
        }
        Type type1 = item1.type;
        if (!(item2 instanceof ANum)) {
            throw QueryError.ARGTYPE_X_X_X.get(this.info, type1, type2, item2);
        }
        return type1 == type2 ? null : (type1 == AtomType.DOUBLE || type2 == AtomType.DOUBLE ? AtomType.DOUBLE : (type1 == AtomType.FLOAT || type2 == AtomType.FLOAT ? AtomType.FLOAT : null));
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        Type type = this.arg((int)0).seqType().type;
        if (type.isNumberOrUntyped()) {
            this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.NUMBER, cc));
        }
        if (this.defined(1)) {
            this.arg(1, arg -> arg.simplifyFor(CompileContext.Simplify.STRING, cc));
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        return this.opt(true, cc);
    }

    final Expr opt(boolean min, CompileContext cc) throws QueryException {
        ArrayList<Stats> list;
        this.arg(0, arg -> arg.simplifyFor(CompileContext.Simplify.DATA, cc).simplifyFor(CompileContext.Simplify.DISTINCT, cc));
        Expr expr = this.optFirst();
        if (expr != this) {
            return expr;
        }
        boolean noColl = !this.defined(1);
        Expr values = this.arg(0);
        SeqType st = values.seqType();
        Type type = st.type;
        if (type.isSortable()) {
            if (type.isUntyped()) {
                type = AtomType.DOUBLE;
            } else if (st.one() && noColl) {
                return values;
            }
            this.exprType.assign(type);
            if (values instanceof Value && noColl) {
                Item item = null;
                Value value = (Value)values;
                long size = value.size();
                if (value instanceof RangeSeq) {
                    RangeSeq seq = (RangeSeq)value;
                    item = seq.itemAt(min ^ seq.asc ? size - 1L : 0L);
                } else if (value instanceof SingletonSeq && ((SingletonSeq)value).singleItem()) {
                    item = value.itemAt(0L);
                } else if (value.isItem()) {
                    item = (Item)value;
                }
                if (item != null && ((type = item.seqType().type).isNumber() || type.instanceOf(AtomType.STRING))) {
                    return item;
                }
            }
        }
        if (noColl && values instanceof Path && (list = ((Path)values).pathStats()) != null) {
            double v = min ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            for (Stats stats : list) {
                if (!StatsType.isNumeric(stats.type)) {
                    return this;
                }
                TokenIntMap map = stats.values;
                if (map == null) {
                    v = min ? Math.min(v, stats.min) : Math.max(v, stats.max);
                    continue;
                }
                for (byte[] value : map) {
                    if (value.length == 0) {
                        return this;
                    }
                    double d = Token.toDouble(value);
                    v = min ? Math.min(v, d) : Math.max(v, d);
                }
            }
            return Dbl.get(v);
        }
        return this;
    }
}

