/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.expr.Range;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public class FnItemsAt
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.seqType().zeroOrOne() ? this.evalItem(qc).iter() : this.evalIter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.seqType().zeroOrOne() ? this.evalItem(qc) : this.evalIter(qc).value(qc, this);
    }

    private Item evalItem(QueryContext qc) throws QueryException {
        Item item;
        Expr input = this.arg(0);
        long at = this.toLong(this.arg(1), qc) - 1L;
        if (at < 0L) {
            return Empty.VALUE;
        }
        if (input.seqType().zeroOrOne()) {
            return at == 0L ? input.item(qc, this.info) : Empty.VALUE;
        }
        Iter iter = input.iter(qc);
        long size = iter.size();
        if (size >= 0L) {
            return at < size ? iter.get(at) : Empty.VALUE;
        }
        long p = at;
        while ((item = qc.next(iter)) != null) {
            if (p-- != 0L) continue;
            return item;
        }
        return Empty.VALUE;
    }

    private Iter evalIter(final QueryContext qc) throws QueryException {
        final Value input = this.arg(0).value(qc);
        final Iter at = this.arg(1).iter(qc);
        final long size = input.size();
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item item;
                while ((item = qc.next(at)) != null) {
                    long a = FnItemsAt.this.toLong(item) - 1L;
                    if (a < 0L || a >= size) continue;
                    return input.itemAt(a);
                }
                return null;
            }
        };
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        long diff;
        Occ occ;
        Expr input = this.arg(0);
        Expr at = this.arg(1);
        SeqType ist = input.seqType();
        SeqType ast = at.seqType();
        if (ist.zero()) {
            return input;
        }
        if (ast.zero()) {
            return Empty.VALUE;
        }
        Occ occ2 = occ = ast.zeroOrOne() ? Occ.ZERO_OR_ONE : Occ.ZERO_OR_MORE;
        if (at instanceof Item && at.size() == 1L) {
            Expr[] args;
            long ps = this.toLong(at, cc.qc) - 1L;
            if (ps < 0L) {
                return Empty.VALUE;
            }
            if (ist.zeroOrOne()) {
                return ps == 0L ? input : Empty.VALUE;
            }
            long size = input.size();
            if (size != -1L) {
                if (ps + 1L == size) {
                    return cc.function(Function.FOOT, this.info, input);
                }
                if (ps + 1L > size) {
                    return Empty.VALUE;
                }
                if (Function.REVERSE.is(input)) {
                    return cc.function(Function.ITEMS_AT, this.info, input.arg(0), Int.get(size - ps));
                }
                occ = Occ.EXACTLY_ONE;
            }
            if (ps == 0L) {
                return cc.function(Function.HEAD, this.info, input);
            }
            if (Function.TAIL.is(input)) {
                return cc.function(Function.ITEMS_AT, this.info, input.arg(0), Int.get(ps + 2L));
            }
            if (Function.REPLICATE.is(input) && (args = input.args())[0].size() == 1L && args[1] instanceof Int) {
                long count = ((Int)args[1]).itr();
                return ps > count ? Empty.VALUE : args[0];
            }
            if (Function._FILE_READ_TEXT_LINES.is(input)) {
                return FileReadTextLines.opt(this, ps, 1L, cc);
            }
            if (input instanceof List) {
                args = input.args();
                int al = args.length;
                for (int a = 0; a < al; ++a) {
                    boolean exact = (long)a == ps;
                    boolean one = args[a].seqType().one();
                    if (exact || !one && a > 0) {
                        if (exact && one) {
                            return args[a];
                        }
                        Expr list = List.get(cc, this.info, Arrays.copyOfRange(args, a, al));
                        return exact ? cc.function(Function.HEAD, this.info, list) : cc.function(Function.ITEMS_AT, this.info, list, Int.get(ps - (long)a + 1L));
                    }
                    if (!one) break;
                }
            }
        }
        if ((diff = FnItemsAt.countInputDiff(this.arg(0), this.arg(1))) != Long.MIN_VALUE) {
            if (diff == 0L) {
                return cc.function(Function.FOOT, this.info, input);
            }
            if (diff > 0L) {
                return Empty.VALUE;
            }
        }
        if (at instanceof RangeSeq) {
            RangeSeq seq = (RangeSeq)at;
            long[] range = seq.range(false);
            Expr expr = cc.function(Function._UTIL_RANGE, this.info, input, Int.get(range[0]), Int.get(range[1]));
            if (!seq.asc) {
                expr = cc.function(Function.REVERSE, this.info, expr);
            }
            return expr;
        }
        if (at instanceof Range) {
            Expr arg1 = at.arg(0);
            Expr arg2 = at.arg(1);
            if (arg1.seqType().instanceOf(SeqType.INTEGER_O) && arg2.seqType().instanceOf(SeqType.INTEGER_O)) {
                return cc.function(Function._UTIL_RANGE, this.info, input, at.arg(0), at.arg(1));
            }
        }
        if (Function.REVERSE.is(at)) {
            return cc.function(Function.REVERSE, this.info, cc.function(Function.ITEMS_AT, this.info, input, at.arg(0)));
        }
        this.exprType.assign(ist.with(occ)).data(input);
        return this.allAreValues(false) ? this.value(cc.qc) : this.embed(cc, false);
    }

    static long countInputDiff(Expr input, Expr end) {
        if (end != Empty.UNDEFINED) {
            Predicate<Expr> countInput = e -> Function.COUNT.is((Expr)e) && e.arg(0).equals(input) && !e.has(Flag.NDT);
            if (countInput.test(end)) {
                return 0L;
            }
            if (end instanceof Arith && countInput.test(end.arg(0)) && end.arg(1) instanceof Int) {
                Calc calc = ((Arith)end).calc;
                long sum = ((Int)end.arg(1)).itr();
                if (calc == Calc.PLUS) {
                    return sum;
                }
                if (calc == Calc.MINUS) {
                    return -sum;
                }
            }
        }
        return Long.MIN_VALUE;
    }
}

