/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.IterFilter;
import org.basex.query.expr.List;
import org.basex.query.expr.Otherwise;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class FnHead
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item input = this.arg(0).iter(qc).next();
        return input == null ? Empty.VALUE : input;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqRange r;
        Expr input = this.arg(0);
        SeqType st = input.seqType();
        if (st.zeroOrOne()) {
            return input;
        }
        long size = input.size();
        if (Function.TAIL.is(input)) {
            return cc.function(Function.ITEMS_AT, this.info, input.arg(0), Int.get(2L));
        }
        if (Function.TRUNK.is(input) && size > 1L) {
            return cc.function(Function.HEAD, this.info, input.args());
        }
        if ((Function.SUBSEQUENCE.is(input) || Function._UTIL_RANGE.is(input)) && (r = SeqRange.get(input, cc)) != null && r.length != 0L) {
            return cc.function(Function.ITEMS_AT, this.info, input.arg(0), Int.get(r.start + 1L));
        }
        if (Function.REVERSE.is(input)) {
            if (input.arg(0) instanceof IterFilter) {
                IterFilter filter = (IterFilter)input.arg(0);
                return cc.function(Function.HEAD, this.info, Filter.get(cc, filter.info(), cc.function(Function.REVERSE, this.info, filter.root), filter.exprs));
            }
            return cc.function(Function.FOOT, this.info, input.args());
        }
        if (Function.REPLICATE.is(input) && input.arg(1) instanceof Int) {
            return cc.function(Function.HEAD, this.info, input.arg(0));
        }
        if (Function._FILE_READ_TEXT_LINES.is(input)) {
            return FileReadTextLines.opt(this, 0L, 1L, cc);
        }
        if (input instanceof List) {
            Expr[] args = input.args();
            Expr first = args[0];
            SeqType stFirst = first.seqType();
            if (stFirst.one()) {
                return first;
            }
            if (stFirst.oneOrMore()) {
                return cc.function(Function.HEAD, this.info, first);
            }
            int al = args.length;
            if (stFirst.zeroOrOne() && (al == 2 || args[1].seqType().occ != Occ.ZERO_OR_ONE)) {
                Expr dflt = List.get(cc, this.info, Arrays.copyOfRange(args, 1, al));
                return new Otherwise(this.info, first, cc.function(Function.HEAD, this.info, dflt)).optimize(cc);
            }
        }
        Occ occ = st.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE;
        this.exprType.assign(st.with(occ)).data(input);
        return this.embed(cc, false);
    }
}

