/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.fn.RegEx;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnAnalyzeString
extends RegEx {
    private static final QNm Q_ANALYZE = new QNm("analyze-string-result", QueryText.FN_URI);
    private static final QNm Q_MATCH = new QNm("match", QueryText.FN_URI);
    private static final QNm Q_NONMATCH = new QNm("non-match", QueryText.FN_URI);
    private static final QNm Q_MGROUP = new QNm("group", QueryText.FN_URI);
    private static final QNm Q_NR = new QNm("nr");

    @Override
    public FNode item(QueryContext qc, InputInfo ii) throws QueryException {
        String value = Token.string(this.toZeroToken(this.arg(0), qc));
        byte[] pattern = this.toToken(this.arg(1), qc);
        Expr flags = this.defined(2) ? this.arg(2) : null;
        Matcher m = this.pattern(pattern, flags, qc, true).matcher(value);
        FBuilder root = FElem.build(Q_ANALYZE).declareNS();
        int start = 0;
        while (m.find()) {
            if (start != m.start()) {
                FnAnalyzeString.nonmatch(value.substring(start, m.start()), root);
            }
            FnAnalyzeString.match(m, value, root, 0);
            start = m.end();
        }
        if (start != value.length()) {
            FnAnalyzeString.nonmatch(value.substring(start), root);
        }
        return root.finish();
    }

    private static int[] match(Matcher matcher, String string, FBuilder parent, int group) {
        FBuilder node = FElem.build(group == 0 ? Q_MATCH : Q_MGROUP);
        if (group > 0) {
            node.add(Q_NR, group);
        }
        int start = matcher.start(group);
        int end = matcher.end(group);
        int gc = matcher.groupCount();
        int[] pos = new int[]{group + 1, start};
        while (pos[0] <= gc && matcher.end(pos[0]) <= end) {
            int st = matcher.start(pos[0]);
            if (st >= 0) {
                if (pos[1] < st) {
                    node.add(string.substring(pos[1], st));
                }
                pos = FnAnalyzeString.match(matcher, string, node, pos[0]);
                continue;
            }
            pos[0] = pos[0] + 1;
        }
        if (pos[1] < end) {
            node.add(string.substring(pos[1], end));
            pos[1] = end;
        }
        parent.add(node);
        return pos;
    }

    private static void nonmatch(String text, FBuilder parent) {
        parent.add(FElem.build(Q_NONMATCH).add(text));
    }
}

