/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public class FileWriteBinary
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        block20: {
            Path path = this.toParent(this.toPath(this.arg(0), qc));
            if (this.defined(2)) {
                Bin binary = this.toBin(this.arg(1), qc);
                long offset = this.toLong(this.arg(2), qc);
                try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
                    long length = raf.length();
                    if (offset < 0L || offset > length) {
                        throw QueryError.FILE_OUT_OF_RANGE_X_X.get(this.info, offset, length);
                    }
                    raf.seek(offset);
                    raf.write(binary.binary(this.info));
                }
            }
            try (BufferOutput out = new BufferOutput(new FileOutputStream(path.toFile(), append));){
                if (this.arg(1).getClass() == ArchiveCreate.class) {
                    ((ArchiveCreate)this.arg(1)).create(out, qc);
                    break block20;
                }
                Bin value = this.toBin(this.arg(1), qc);
                try (BufferInput bi = value.input(this.info);){
                    int b;
                    while ((b = bi.read()) != -1) {
                        out.write(b);
                    }
                }
            }
        }
    }
}

