/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public final class FileDelete
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws QueryException, IOException {
        Path path = this.toPath(this.arg(0), qc);
        boolean recursive = this.toBooleanOrFalse(this.arg(1), qc);
        if (recursive) {
            this.delete(path, qc);
        } else {
            Files.delete(path);
        }
        return Empty.VALUE;
    }

    private synchronized void delete(Path path, QueryContext qc) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(path);){
                qc.checkStop();
                for (Path child : children) {
                    this.delete(child, qc);
                }
            }
        }
        Files.delete(path);
    }
}

