/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.io.IOException;
import org.basex.core.Store;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.io.IOFile;
import org.basex.io.in.DataInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.db.DbAccess;
import org.basex.query.value.Value;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;

public class DbGetValue
extends DbAccess {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.value(ResourceType.VALUE, qc);
    }

    final Value value(ResourceType type, QueryContext qc) throws QueryException {
        Data data = this.toData(qc);
        if (data.inMemory()) {
            throw QueryError.DB_MAINMEM_X.get(this.info, data.meta.name);
        }
        try {
            if (this.defined(1)) {
                String path = this.toDbPath(this.arg(1), qc);
                IOFile bin = data.meta.file(path, type);
                if (!bin.exists() || bin.isDir()) {
                    throw QueryError.WHICHRES_X.get(this.info, path);
                }
                return this.resource(bin, qc);
            }
            MapBuilder mb = new MapBuilder(this.info);
            IOFile bin = data.meta.dir(type);
            for (String path : data.resources.paths("", type)) {
                mb.put(path, this.resource(type.filePath(bin, path), qc));
            }
            return mb.map();
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(this.info, ex);
        }
    }

    Value resource(IOFile path, QueryContext qc) throws IOException, QueryException {
        try (DataInput in = new DataInput(path);){
            Value value = Store.read(in, qc);
            return value;
        }
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (!this.defined(1)) {
            this.exprType.assign(MapType.get(AtomType.STRING, SeqType.ITEM_ZM).seqType());
        }
        return this;
    }
}

