/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.convert;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.IntSeq;
import org.basex.util.list.LongList;

public final class ConvertBinaryToIntegers
extends StandardFunc {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final byte[] bytes = this.toBin(this.arg(0), qc).binary(this.info);
        return new BasicIter<Int>((long)bytes.length){

            @Override
            public Int get(long i) {
                return Int.get(bytes[(int)i] & 0xFF);
            }

            @Override
            public Value value(QueryContext q, Expr expr) {
                return ConvertBinaryToIntegers.toValue(bytes);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return ConvertBinaryToIntegers.toValue(this.toBin(this.arg(0), qc).binary(this.info));
    }

    public static Value toValue(byte[] bytes) {
        int bl = bytes.length;
        if (bl == 1) {
            return Int.get(bytes[0] & 0xFF);
        }
        LongList list = new LongList(bl);
        for (byte b : bytes) {
            list.add((long)(b & 0xFF));
        }
        return IntSeq.get(list);
    }
}

