/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;

public class ArraySplit
extends ArrayFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        final XQArray array = this.toArray(this.arg(0), qc);
        return new Iter(){
            final Iterator<Value> members;
            {
                this.members = array.members().iterator();
            }

            @Override
            public XQArray next() {
                return this.members.hasNext() ? XQArray.member(this.members.next()) : null;
            }

            @Override
            public Item get(long i) {
                return XQArray.member(array.get(i));
            }

            @Override
            public long size() {
                return array.arraySize();
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.arg(0), qc);
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value member : array.members()) {
            vb.add(XQArray.member(member));
        }
        return vb.value();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr array = this.arg(0);
        if (array == XQArray.empty()) {
            return Empty.VALUE;
        }
        FuncType ft = array.funcType();
        if (ft instanceof ArrayType) {
            this.exprType.assign(ft.seqType(Occ.ZERO_OR_MORE));
        }
        return this;
    }
}

