/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import org.basex.core.MainOptions;
import org.basex.io.in.ArrayInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.archive.ArchiveText;
import org.basex.query.func.convert.ConvertFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Item;
import org.basex.util.hash.TokenSet;

abstract class ArchiveFn
extends StandardFunc {
    ArchiveFn() {
    }

    final Item checkElemToken(Item item, QueryContext qc) throws QueryException {
        return item instanceof AStr ? item : this.toElem(item, ArchiveText.Q_ENTRY, qc, QueryError.ELMSTR_X_X_X);
    }

    final byte[] encode(byte[] value, String encoding, QueryContext qc) throws QueryException {
        try {
            boolean validate = qc.context.options.get(MainOptions.CHECKSTRINGS);
            return ConvertFn.toString(new ArrayInput(value), encoding, validate);
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ENCODE2_X.get(this.info, ex);
        }
    }

    final TokenSet entries(Expr expr, QueryContext qc) throws QueryException {
        Item item;
        TokenSet set = new TokenSet();
        Iter names = expr.iter(qc);
        while ((item = qc.next(names)) != null) {
            set.add(this.checkElemToken(item, qc).string(this.info));
        }
        return set.isEmpty() ? null : set;
    }
}

