/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.basex.io.in.BufferInput;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveFn;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.B64;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

public class ArchiveExtractBinary
extends ArchiveFn {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] bytes : this.extract(qc)) {
            vb.add(B64.get(bytes));
        }
        return vb.value(this);
    }

    final TokenList extract(QueryContext qc) throws QueryException {
        B64 archive = this.toB64(this.arg(0), qc);
        TokenSet entries = this.entries(this.arg(1), qc);
        TokenList tl = new TokenList();
        try (BufferInput bi = archive.input(this.info);
             ArchiveIn in = ArchiveIn.get(bi, this.info);){
            while (in.more()) {
                ZipEntry ze = in.entry();
                if (ze.isDirectory() || entries != null && entries.remove(Token.token(ze.getName())) == 0) continue;
                ArrayOutput out = new ArrayOutput();
                in.write(out);
                tl.add(out.finish());
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
        return tl;
    }
}

